/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.client.rest.TestCase;
import alluxio.client.rest.TestCaseOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.network.NetworkAddressUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class WebServerIntegrationTest
extends BaseIntegrationTest {
    private static final Multimap<NetworkAddressUtils.ServiceType, String> PAGES = new ImmutableListMultimap.Builder().putAll((Object)NetworkAddressUtils.ServiceType.MASTER_WEB, (Object[])new String[]{"/"}).putAll((Object)NetworkAddressUtils.ServiceType.WORKER_WEB, (Object[])new String[]{"/"}).build();
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();

    @Test
    public void metricsJson() throws Exception {
        for (NetworkAddressUtils.ServiceType serviceType : PAGES.keys()) {
            this.verifyMetricsJson(serviceType);
        }
    }

    private void verifyMetricsJson(NetworkAddressUtils.ServiceType serviceType) throws Exception {
        InetSocketAddress address = this.getInetSocketAddresss(serviceType);
        HashMap<String, String> params = new HashMap<String, String>();
        String result = new TestCase(address.getHostName(), address.getPort(), "/metrics/json", "", params, "GET", TestCaseOptions.defaults()).runAndGetResponse();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap metrics = (HashMap)new ObjectMapper().readValue(result, (TypeReference)typeRef);
        Assert.assertTrue((boolean)metrics.containsKey("version"));
        Assert.assertTrue((boolean)metrics.containsKey("counters"));
    }

    @Test
    public void serverUp() throws Exception {
        for (Map.Entry entry : PAGES.entries()) {
            this.verifyWebService((NetworkAddressUtils.ServiceType)entry.getKey(), (String)entry.getValue());
        }
    }

    @Test
    public void tempDirectoryCreated() {
        Files.isDirectory(Paths.get(this.mLocalAlluxioClusterResource.get().getAlluxioHome(), "web"), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyWebService(NetworkAddressUtils.ServiceType serviceType, String path) throws IOException {
        InetSocketAddress webAddr = this.getInetSocketAddresss(serviceType);
        HttpURLConnection webService = (HttpURLConnection)new URL("http://" + webAddr.getAddress().getHostAddress() + ":" + webAddr.getPort() + path).openConnection();
        webService.connect();
        Assert.assertEquals((long)200L, (long)webService.getResponseCode());
        Scanner pageScanner = null;
        boolean verified = false;
        try {
            pageScanner = new Scanner(webService.getInputStream());
            while (pageScanner.hasNextLine()) {
                String line = pageScanner.nextLine();
                if (!line.contains("<title>Alluxio Master</title>") && !line.contains("<title>Alluxio Worker</title>")) continue;
                verified = true;
                break;
            }
        }
        finally {
            if (pageScanner != null) {
                pageScanner.close();
            }
            webService.disconnect();
        }
        Assert.assertTrue((String)String.format("%s was started but not successfully verified.", serviceType.getServiceName()), (boolean)verified);
    }

    private InetSocketAddress getInetSocketAddresss(NetworkAddressUtils.ServiceType serviceType) {
        int port = serviceType == NetworkAddressUtils.ServiceType.MASTER_WEB ? this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getWebAddress().getPort() : this.mLocalAlluxioClusterResource.get().getWorkerProcess().getWebLocalPort();
        InetSocketAddress webAddr = new InetSocketAddress(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)serviceType, (AlluxioConfiguration)Configuration.global()), port);
        return webAddr;
    }
}

