/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.master.backcompat.FsTestOp;
import alluxio.master.backcompat.Utils;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import java.util.Arrays;
import org.junit.Assert;

public final class CreateFile
extends FsTestOp {
    private static final AlluxioURI PATH = new AlluxioURI("/createFile");
    private static final AlluxioURI NESTED = new AlluxioURI("/createFileNested/a");
    private static final Mode TEST_MODE = ModeParser.parse((String)"u=rw,g=x");
    private static final AlluxioURI MODE = new AlluxioURI("/createFileMode/a");
    private static final AlluxioURI THROUGH = new AlluxioURI("/createFileThrough/a");
    private static final long TEST_TTL = 0x3FFFFFFFFFFFFFFFL;
    private static final AlluxioURI TTL = new AlluxioURI("/createFileTtl/a");

    @Override
    public void apply(FileSystem fs) throws Exception {
        Utils.createFile(fs, PATH);
        Utils.createFile(fs, NESTED);
        Utils.createFile(fs, MODE, CreateFilePOptions.newBuilder().setBlockSizeBytes(1024L).setRecursive(true).setMode(TEST_MODE.toProto()).build());
        Utils.createFile(fs, THROUGH, CreateFilePOptions.newBuilder().setBlockSizeBytes(1024L).setRecursive(true).setWriteType(WritePType.THROUGH).build());
        Utils.createFile(fs, TTL, CreateFilePOptions.newBuilder().setBlockSizeBytes(1024L).setRecursive(true).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(0x3FFFFFFFFFFFFFFFL).setTtlAction(TtlAction.FREE)).build());
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        for (AlluxioURI file : Arrays.asList(PATH, NESTED, THROUGH, TTL)) {
            Assert.assertTrue((boolean)fs.exists(file));
        }
        Assert.assertEquals((Object)TEST_MODE, (Object)new Mode((short)fs.getStatus(MODE).getMode()));
        Assert.assertTrue((boolean)fs.getStatus(THROUGH).isPersisted());
        Assert.assertEquals((long)0x3FFFFFFFFFFFFFFFL, (long)fs.getStatus(TTL).getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)fs.getStatus(TTL).getTtlAction());
    }
}

