/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs;

import alluxio.AlluxioURI;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.cli.fs.AbstractShellIntegrationTest;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.master.job.JobMaster;
import alluxio.security.group.GroupMappingService;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class AbstractFileSystemShellTest
extends AbstractShellIntegrationTest {
    public static LocalAlluxioCluster sLocalAlluxioCluster;
    public static FileSystem sFileSystem;
    public static FileSystemShell sFsShell;
    protected static JobMaster sJobMaster;
    protected static LocalAlluxioJobCluster sLocalAlluxioJobCluster;
    protected static final TestUser TEST_USER_1;
    protected static final TestUser TEST_USER_2;

    @BeforeClass
    public static void beforeClass() throws Exception {
        sLocalAlluxioCluster = sLocalAlluxioClusterResource.get();
        sLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        sLocalAlluxioJobCluster.start();
        sFileSystem = sLocalAlluxioCluster.getClient();
        sJobMaster = sLocalAlluxioJobCluster.getMaster().getJobMaster();
        sFsShell = new FileSystemShell(Configuration.global());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (sFsShell != null) {
            sFsShell.close();
        }
        if (sLocalAlluxioJobCluster != null) {
            sLocalAlluxioJobCluster.stop();
        }
    }

    protected void copyToLocalWithBytes(int bytes) throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)bytes);
        sFsShell.run(new String[]{"copyToLocal", "/testFile", sLocalAlluxioCluster.getAlluxioHome() + "/testFile"});
        Assert.assertEquals((Object)this.getCommandOutput(new String[]{"copyToLocal", "/testFile", sLocalAlluxioCluster.getAlluxioHome() + "/testFile"}), (Object)this.mOutput.toString());
        this.fileReadTest("/testFile", 10);
    }

    protected void fileReadTest(String fileName, int size) throws IOException {
        File testFile = new File(PathUtils.concatPath((Object)sLocalAlluxioCluster.getAlluxioHome(), (Object)fileName));
        FileInputStream fis = new FileInputStream(testFile);
        byte[] read = new byte[size];
        fis.read(read);
        fis.close();
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)size, (byte[])read));
    }

    protected File generateFileContent(String path, byte[] toWrite) throws IOException, FileNotFoundException {
        File testFile = new File(sLocalAlluxioCluster.getAlluxioHome() + path);
        testFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        fos.write(toWrite);
        fos.close();
        return testFile;
    }

    protected File generateRelativeFileContent(String path, byte[] toWrite) throws IOException, FileNotFoundException {
        File testFile = new File(path);
        testFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(testFile);
        fos.write(toWrite);
        fos.close();
        return testFile;
    }

    @Nullable
    protected String getCommandOutput(String[] command) {
        String cmd = command[0];
        if (command.length == 2) {
            switch (cmd) {
                case "ls": {
                    return null;
                }
                case "mkdir": {
                    return "Successfully created directory " + command[1] + "\n";
                }
                case "rm": 
                case "rmr": {
                    return command[1] + " has been removed\n";
                }
                case "touch": {
                    return command[1] + " has been created\n";
                }
            }
            return null;
        }
        if (command.length == 3) {
            switch (cmd) {
                case "mv": {
                    return "Renamed " + command[1] + " to " + command[2] + "\n";
                }
                case "copyFromLocal": {
                    return "Copied file://" + command[1] + " to " + command[2] + "\n";
                }
                case "copyToLocal": {
                    return "Copied " + command[1] + " to file://" + command[2] + "\n";
                }
                case "cp": {
                    return "Copied " + command[1] + " to " + command[2] + "\n";
                }
            }
            return null;
        }
        if (command.length > 3) {
            if (cmd.equals("location")) {
                StringBuilder ret = new StringBuilder();
                ret.append(command[1] + " with file id " + command[2] + " is on nodes: \n");
                for (int i = 3; i < command.length; ++i) {
                    ret.append(command[i] + "\n");
                }
                return ret.toString();
            }
            if (cmd.equals("fileInfo")) {
                StringBuilder ret = new StringBuilder();
                ret.append(command[1] + " with file id " + command[2] + " has the following blocks: \n");
                for (int i = 3; i < command.length; ++i) {
                    ret.append(command[i] + "\n");
                }
                return ret.toString();
            }
        }
        return null;
    }

    protected byte[] readContent(AlluxioURI uri, int length) throws IOException, AlluxioException {
        try (FileInStream tfis = sFileSystem.openFile(uri, OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            byte[] read = new byte[length];
            tfis.read(read);
            byte[] byArray = read;
            return byArray;
        }
    }

    protected boolean isInMemoryTest(String path) throws IOException, AlluxioException {
        return sFileSystem.getStatus(new AlluxioURI(path)).getInMemoryPercentage() == 100;
    }

    protected boolean fileExists(AlluxioURI path) {
        try {
            return sFileSystem.exists(path);
        }
        catch (IOException e) {
            return false;
        }
        catch (AlluxioException e) {
            return false;
        }
    }

    protected boolean fileExistsInAlluxio(AlluxioURI path) {
        try {
            return sFileSystem.exists(path, ExistsPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).build()).build());
        }
        catch (IOException e) {
            return false;
        }
        catch (AlluxioException e) {
            return false;
        }
    }

    protected void checkFilePersisted(AlluxioURI uri, int size) throws Exception {
        Assert.assertTrue((boolean)sFileSystem.getStatus(uri).isPersisted());
        CommonUtils.waitFor((String)"file to be completely freed", () -> {
            try {
                sFileSystem.free(uri);
                return sFileSystem.getStatus(uri).getInAlluxioPercentage() == 0;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
        try (FileInStream tfis = sFileSystem.openFile(uri);){
            byte[] actual = new byte[size];
            tfis.read(actual);
            Assert.assertArrayEquals((byte[])BufferUtils.getIncreasingByteArray((int)size), (byte[])actual);
        }
    }

    protected void verifyCommandReturnValueAndOutput(int expectedReturnValue, String expectedOutput, String ... command) {
        int ret = sFsShell.run(command);
        Assert.assertEquals((long)expectedReturnValue, (long)ret);
        Assert.assertTrue((boolean)this.mOutput.toString().contains(expectedOutput));
    }

    static {
        TEST_USER_1 = new TestUser("alice", "alice,staff");
        TEST_USER_2 = new TestUser("bob", "bob,staff");
    }

    public static class FakeUserGroupsMapping
    implements GroupMappingService {
        private HashMap<String, String> mUserGroups = new HashMap();

        public FakeUserGroupsMapping() {
            this.mUserGroups.put(TEST_USER_1.getUser(), TEST_USER_1.getGroup());
            this.mUserGroups.put(TEST_USER_2.getUser(), TEST_USER_2.getGroup());
        }

        public List<String> getGroups(String user) throws IOException {
            if (this.mUserGroups.containsKey(user)) {
                return Lists.newArrayList((Object[])this.mUserGroups.get(user).split(","));
            }
            return new ArrayList<String>();
        }
    }

    protected static final class TestUser {
        private String mUser;
        private String mGroup;

        TestUser(String user, String group) {
            this.mUser = user;
            this.mGroup = group;
        }

        public String getUser() {
            return this.mUser;
        }

        public String getGroup() {
            return this.mGroup;
        }
    }
}

