/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.Command;
import alluxio.cli.fs.FileSystemShell;
import alluxio.cli.fs.FileSystemShellUtils;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class FileSystemShellUtilsTest {
    public static final String TEST_DIR = "/testDir";
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private FileSystem mFileSystem = null;

    @Before
    public final void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Test
    public void getFilePath() throws IOException {
        String[] paths = new String[]{"alluxio://localhost:19998/dir", "/dir", "dir"};
        String expected = "/dir";
        for (String path : paths) {
            String result = FileSystemShellUtils.getFilePath((String)path, (AlluxioConfiguration)Configuration.global());
            Assert.assertEquals((Object)expected, (Object)result);
        }
    }

    public String resetFileHierarchy() throws IOException, AlluxioException {
        return FileSystemShellUtilsTest.resetFileHierarchy(this.mFileSystem);
    }

    public static String resetFileHierarchy(FileSystem fs) throws IOException, AlluxioException {
        return FileSystemShellUtilsTest.resetFileHierarchy(fs, WritePType.MUST_CACHE);
    }

    public static String resetFileHierarchy(FileSystem fs, WritePType writeType) throws IOException, AlluxioException {
        if (fs.exists(new AlluxioURI(TEST_DIR))) {
            fs.delete(new AlluxioURI(TEST_DIR), DeletePOptions.newBuilder().setRecursive(true).build());
        }
        CreateDirectoryPOptions dirOptions = CreateDirectoryPOptions.getDefaultInstance().toBuilder().setWriteType(writeType).build();
        fs.createDirectory(new AlluxioURI(TEST_DIR), dirOptions);
        fs.createDirectory(new AlluxioURI("/testDir/foo"), dirOptions);
        fs.createDirectory(new AlluxioURI("/testDir/bar"), dirOptions);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testDir/foo/foobar1", (WritePType)writeType, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testDir/foo/foobar2", (WritePType)writeType, (int)20);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testDir/bar/foobar3", (WritePType)writeType, (int)30);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/testDir/foobar4", (WritePType)writeType, (int)40);
        return TEST_DIR;
    }

    public String resetLocalFileHierarchy() throws IOException {
        return FileSystemShellUtilsTest.resetLocalFileHierarchy(this.mLocalAlluxioClusterResource.get());
    }

    public static String resetLocalFileHierarchy(LocalAlluxioCluster localAlluxioCluster) throws IOException {
        FileUtils.deleteDirectory((File)new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR));
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR).mkdir();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/foo").mkdir();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/bar").mkdir();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/foo/foobar1").createNewFile();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/foo/foobar2").createNewFile();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/bar/foobar3").createNewFile();
        new File(localAlluxioCluster.getAlluxioHome() + TEST_DIR + "/foobar4").createNewFile();
        return localAlluxioCluster.getAlluxioHome() + TEST_DIR;
    }

    public List<String> getPaths(String path, FsType fsType) throws IOException {
        ArrayList<String> ret = null;
        if (fsType == FsType.TFS) {
            List tPaths = FileSystemShellUtils.getAlluxioURIs((FileSystem)this.mFileSystem, (AlluxioURI)new AlluxioURI(path));
            ret = new ArrayList(tPaths.size());
            for (AlluxioURI tPath : tPaths) {
                ret.add(tPath.getPath());
            }
        } else if (fsType == FsType.LOCAL) {
            List tPaths = FileSystemShellUtils.getFiles((String)path);
            ret = new ArrayList<String>(tPaths.size());
            for (File tPath : tPaths) {
                ret.add(tPath.getPath());
            }
        }
        Collections.sort(ret);
        return ret;
    }

    @Nullable
    public String resetFsHierarchy(FsType fsType) throws IOException, AlluxioException {
        if (fsType == FsType.TFS) {
            return this.resetFileHierarchy();
        }
        if (fsType == FsType.LOCAL) {
            return this.resetLocalFileHierarchy();
        }
        return null;
    }

    @Test
    public void getPath() throws IOException, AlluxioException {
        for (FsType fsType : FsType.values()) {
            String rootDir = this.resetFsHierarchy(fsType);
            List<String> tl1 = this.getPaths(rootDir + "/foo", fsType);
            Assert.assertEquals((long)tl1.size(), (long)1L);
            Assert.assertEquals((Object)tl1.get(0), (Object)(rootDir + "/foo"));
            List<String> tl2 = this.getPaths(rootDir + "/foo/", fsType);
            Assert.assertEquals((long)tl2.size(), (long)1L);
            Assert.assertEquals((Object)tl2.get(0), (Object)(rootDir + "/foo"));
            List<String> tl3 = this.getPaths(rootDir + "/foo/*", fsType);
            Assert.assertEquals((long)tl3.size(), (long)2L);
            Assert.assertEquals((Object)tl3.get(0), (Object)(rootDir + "/foo/foobar1"));
            Assert.assertEquals((Object)tl3.get(1), (Object)(rootDir + "/foo/foobar2"));
            List<String> tl4 = this.getPaths(rootDir + "/foo/*/", fsType);
            Assert.assertEquals((long)tl4.size(), (long)2L);
            Assert.assertEquals((Object)tl4.get(0), (Object)(rootDir + "/foo/foobar1"));
            Assert.assertEquals((Object)tl4.get(1), (Object)(rootDir + "/foo/foobar2"));
            List<String> tl5 = this.getPaths(rootDir + "/*/foo*", fsType);
            Assert.assertEquals((long)tl5.size(), (long)3L);
            Assert.assertEquals((Object)tl5.get(0), (Object)(rootDir + "/bar/foobar3"));
            Assert.assertEquals((Object)tl5.get(1), (Object)(rootDir + "/foo/foobar1"));
            Assert.assertEquals((Object)tl5.get(2), (Object)(rootDir + "/foo/foobar2"));
        }
    }

    @Test
    public void match() {
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"/a/*"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"/a/*/"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"/a/*/c"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"/a/*/*"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"/a/*/*/"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c/", (String)"/a/*/*/"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c/", (String)"/a/*/*"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/foo/bar/foobar/", (String)"/foo*/*"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/foo/bar/foobar/", (String)"/*/*/foobar"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c/", (String)"/b/*"), (Object)false);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/", (String)"/*/*"), (Object)false);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/a/b/c", (String)"*"), (Object)true);
        Assert.assertEquals((Object)FileSystemShellUtils.match((String)"/", (String)"/*"), (Object)true);
    }

    @Test
    public void getIntArgTest() throws Exception {
        Option opt = Option.builder((String)"t").longOpt("test").numberOfArgs(1).required(false).build();
        CommandLine cmdLine = this.getCmdLine(opt, "--test", "1");
        Assert.assertEquals((String)"Should get long form", (long)1L, (long)FileSystemShellUtils.getIntArg((CommandLine)cmdLine, (Option)opt, (int)0));
        cmdLine = this.getCmdLine(opt, "-t", "5");
        Assert.assertEquals((String)"Should get short form", (long)5L, (long)FileSystemShellUtils.getIntArg((CommandLine)cmdLine, (Option)opt, (int)0));
        cmdLine = this.getCmdLine(opt, new String[0]);
        Assert.assertEquals((String)"Should not get arg", (long)0L, (long)FileSystemShellUtils.getIntArg((CommandLine)cmdLine, (Option)opt, (int)0));
    }

    CommandLine getCmdLine(Option opt, String ... args) throws Exception {
        DefaultParser parser = new DefaultParser();
        return parser.parse(new Options().addOption(opt), args);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jianjian", comment="fix or remove this test")
    public void loadCommands() {
        Map map = FileSystemShellUtils.loadCommands((FileSystemContext)FileSystemContext.create((AlluxioConfiguration)Configuration.global()));
        String pkgName = Command.class.getPackage().getName();
        Reflections reflections = new Reflections(pkgName, new Scanner[0]);
        Set cmdSet = reflections.getSubTypesOf(Command.class);
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertEquals((Object)((Command)entry.getValue()).getCommandName(), entry.getKey());
            Assert.assertEquals((Object)cmdSet.contains(((Command)entry.getValue()).getClass()), (Object)true);
        }
        int expectSize = 0;
        for (Class cls : cmdSet) {
            if (!cls.getPackage().getName().equals(FileSystemShell.class.getPackage().getName() + ".command") || Modifier.isAbstract(cls.getModifiers())) continue;
            ++expectSize;
        }
        Assert.assertEquals((long)expectSize, (long)map.size());
    }

    public static enum FsType {
        TFS,
        LOCAL;

    }
}

