/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs;

import alluxio.ClientContext;
import alluxio.SystemOutRule;
import alluxio.SystemPropertyRule;
import alluxio.cli.GetConf;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ConfigProperty;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.wire.Configuration;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class GetConfTest {
    private ByteArrayOutputStream mOutputStream = new ByteArrayOutputStream();
    @Rule
    public SystemOutRule mOutputStreamRule = new SystemOutRule((OutputStream)this.mOutputStream);

    @After
    public void after() {
        alluxio.conf.Configuration.reloadProperties();
    }

    @Test
    public void getConf() throws Exception {
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2048");
        ClientContext ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2048\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2MB");
        ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2MB\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)2048);
        ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2048\n", (Object)this.mOutputStream.toString());
    }

    @Test
    public void getConfByAlias() {
        PropertyKey testProperty = PropertyKey.Builder.stringBuilder((String)"alluxio.test.property").setAlias(new String[]{"alluxio.test.property.alias"}).setDefaultValue((Object)"testValue").build();
        ClientContext ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"alluxio.test.property.alias"}));
        Assert.assertEquals((Object)"testValue\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"alluxio.test.property"}));
        Assert.assertEquals((Object)"testValue\n", (Object)this.mOutputStream.toString());
        PropertyKey.unregister((PropertyKey)testProperty);
    }

    @Test
    public void getConfWithCorrectUnit() throws Exception {
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2048");
        ClientContext ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"--unit", "B", PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2048\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2048");
        ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"--unit", "KB", PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2MB");
        ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"--unit", "KB", PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2048\n", (Object)this.mOutputStream.toString());
        this.mOutputStream.reset();
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2MB");
        ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
        Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{"--unit", "MB", PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
        Assert.assertEquals((Object)"2\n", (Object)this.mOutputStream.toString());
    }

    @Test
    public void getConfWithWrongUnit() throws Exception {
        alluxio.conf.Configuration.set((PropertyKey)PropertyKey.WORKER_RAMDISK_SIZE, (Object)"2048");
        Assert.assertEquals((long)1L, (long)GetConf.getConf((ClientContext)ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global()), (String[])new String[]{"--unit", "bad_unit", PropertyKey.WORKER_RAMDISK_SIZE.toString()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getConfWithInvalidConf() throws Exception {
        try (Closeable p = new SystemPropertyRule((Map)ImmutableMap.of((Object)PropertyKey.CONF_VALIDATION_ENABLED.toString(), (Object)"false", (Object)PropertyKey.ZOOKEEPER_ENABLED.toString(), (Object)"true")).toResource();){
            alluxio.conf.Configuration.reloadProperties();
            ClientContext ctx = ClientContext.create((AlluxioConfiguration)alluxio.conf.Configuration.global());
            Assert.assertEquals((long)0L, (long)GetConf.getConf((ClientContext)ctx, (String[])new String[]{PropertyKey.ZOOKEEPER_ENABLED.toString()}));
            Assert.assertEquals((Object)"true\n", (Object)this.mOutputStream.toString());
        }
        finally {
            alluxio.conf.Configuration.reloadProperties();
        }
    }

    @Test
    public void getConfFromMaster() throws Exception {
        RetryHandlingMetaMasterConfigClient client = (RetryHandlingMetaMasterConfigClient)Mockito.mock(RetryHandlingMetaMasterConfigClient.class);
        Mockito.when((Object)client.getConfiguration((GetConfigurationPOptions)ArgumentMatchers.any())).thenReturn((Object)Configuration.fromProto((GetConfigurationPResponse)this.prepareGetConfigurationResponse()));
        Assert.assertEquals((long)0L, (long)GetConf.getConfImpl(() -> client, (AlluxioConfiguration)alluxio.conf.Configuration.global(), (String[])new String[]{"--master"}));
        String expectedOutput = "alluxio.logger.type=MASTER_LOGGER\nalluxio.master.audit.logger.type=MASTER_AUDIT_LOGGER\nalluxio.master.hostname=localhost\nalluxio.master.mount.table.root.ufs=hdfs://localhost:9000\nalluxio.master.rpc.port=19998\nalluxio.master.web.port=19999\n";
        Assert.assertEquals((Object)expectedOutput, (Object)this.mOutputStream.toString());
    }

    @Test
    public void getConfFromMasterWithSource() throws Exception {
        RetryHandlingMetaMasterConfigClient client = (RetryHandlingMetaMasterConfigClient)Mockito.mock(RetryHandlingMetaMasterConfigClient.class);
        Mockito.when((Object)client.getConfiguration((GetConfigurationPOptions)ArgumentMatchers.any())).thenReturn((Object)Configuration.fromProto((GetConfigurationPResponse)this.prepareGetConfigurationResponse()));
        Assert.assertEquals((long)0L, (long)GetConf.getConfImpl(() -> client, (AlluxioConfiguration)alluxio.conf.Configuration.global(), (String[])new String[]{"--master", "--source"}));
        String expectedOutput = "alluxio.logger.type=MASTER_LOGGER (SYSTEM_PROPERTY)\nalluxio.master.audit.logger.type=MASTER_AUDIT_LOGGER (SYSTEM_PROPERTY)\nalluxio.master.hostname=localhost (SITE_PROPERTY (/alluxio/conf/alluxio-site.properties))\nalluxio.master.mount.table.root.ufs=hdfs://localhost:9000 (SITE_PROPERTY (/alluxio/conf/alluxio-site.properties))\nalluxio.master.rpc.port=19998 (DEFAULT)\nalluxio.master.web.port=19999 (DEFAULT)\n";
        Assert.assertEquals((Object)expectedOutput, (Object)this.mOutputStream.toString());
    }

    private List<ConfigProperty> prepareConfigList() {
        return Arrays.asList(ConfigProperty.newBuilder().setName("alluxio.master.rpc.port").setValue("19998").setSource("DEFAULT").build(), ConfigProperty.newBuilder().setName("alluxio.master.web.port").setValue("19999").setSource("DEFAULT").build(), ConfigProperty.newBuilder().setName("alluxio.master.hostname").setValue("localhost").setSource("SITE_PROPERTY (/alluxio/conf/alluxio-site.properties)").build(), ConfigProperty.newBuilder().setName("alluxio.master.mount.table.root.ufs").setValue("hdfs://localhost:9000").setSource("SITE_PROPERTY (/alluxio/conf/alluxio-site.properties)").build(), ConfigProperty.newBuilder().setName("alluxio.logger.type").setValue("MASTER_LOGGER").setSource("SYSTEM_PROPERTY").build(), ConfigProperty.newBuilder().setName("alluxio.master.audit.logger.type").setValue("MASTER_AUDIT_LOGGER").setSource("SYSTEM_PROPERTY").build());
    }

    private GetConfigurationPResponse prepareGetConfigurationResponse() {
        return GetConfigurationPResponse.newBuilder().addAllClusterConfigs(this.prepareConfigList()).build();
    }
}

