/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.Configuration;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.master.MultiMasterLocalAlluxioCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public final class JobServiceFaultToleranceShellTest
extends BaseIntegrationTest {
    private MultiMasterLocalAlluxioCluster mLocalAlluxioCluster;
    private LocalAlluxioJobCluster mLocalAlluxioJobCluster;
    private ByteArrayOutputStream mOutput;
    @Rule
    public TestName mTestName = new TestName();

    @Before
    public void before() throws Exception {
        this.mLocalAlluxioCluster = new MultiMasterLocalAlluxioCluster(2);
        this.mLocalAlluxioCluster.initConfiguration(IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName()));
        this.mLocalAlluxioCluster.start();
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
        this.mOutput = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.mOutput));
    }

    @After
    public void after() throws Exception {
        if (this.mLocalAlluxioJobCluster != null) {
            this.mLocalAlluxioJobCluster.stop();
        }
        if (this.mLocalAlluxioCluster != null) {
            this.mLocalAlluxioCluster.stop();
        }
        System.setOut(System.out);
        Configuration.reloadProperties();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="bowen", comment="job master and job worker are deprecated")
    public void distributedCp() throws Exception {
        FileSystem fs = FileSystem.Factory.create();
        try (FileOutStream out = fs.createFile(new AlluxioURI("/test"));){
            out.write("Hello".getBytes());
        }
        var3_3 = null;
        try (FileSystemShell shell = new FileSystemShell(Configuration.global());){
            int exitCode = shell.run(new String[]{"distributedCp", "/test", "/test2"});
            Assert.assertEquals((String)("Command failed, output: " + this.mOutput.toString()), (long)0L, (long)exitCode);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)fs.exists(new AlluxioURI("/test2")));
    }
}

