/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.util.io.BufferUtils;
import java.io.File;
import java.io.PrintWriter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="ignored due to broken test infrastructure")
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="the cluster is not properly cleaned up before each test run, see alluxio.testutils.LocalAlluxioClusterResource.ResetRule.resetCluster")
public final class CatCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void catDirectory() throws Exception {
        String[] command = new String[]{"mkdir", "/testDir"};
        sFsShell.run(command);
        int ret = sFsShell.run(new String[]{"cat", "/testDir"});
        Assert.assertEquals((long)-1L, (long)ret);
        String expected = this.getCommandOutput(command);
        expected = expected + "Path \"/testDir\" must be a file.\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void catNotExist() throws Exception {
        int ret = sFsShell.run(new String[]{"cat", "/testFile"});
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void cat() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"cat", "/testFile"});
        byte[] expect = BufferUtils.getIncreasingByteArray((int)10);
        Assert.assertArrayEquals((byte[])expect, (byte[])this.mOutput.toByteArray());
    }

    @Test
    public void catWildcard() throws Exception {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        byte[] exp1 = BufferUtils.getIncreasingByteArray((int)30);
        byte[] exp2 = BufferUtils.getIncreasingByteArray((int)10);
        byte[] exp3 = BufferUtils.getIncreasingByteArray((int)20);
        byte[] expect = new byte[exp1.length + exp2.length + exp3.length];
        System.arraycopy(exp1, 0, expect, 0, exp1.length);
        System.arraycopy(exp2, 0, expect, exp1.length, exp2.length);
        System.arraycopy(exp3, 0, expect, exp1.length + exp2.length, exp3.length);
        int ret = sFsShell.run(new String[]{"cat", testDir + "/*/foo*"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertArrayEquals((byte[])this.mOutput.toByteArray(), (byte[])expect);
    }

    @Test
    public void catAfterForceMasterSync() throws Exception {
        String testFilePath = "/testPersist/testFile";
        int size = 100;
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)testFilePath, (WritePType)WritePType.THROUGH, (int)size);
        Assert.assertTrue((boolean)sFileSystem.getStatus(new AlluxioURI("/testPersist/testFile")).isPersisted());
        String rootUfsDir = sLocalAlluxioCluster.getClient().getConf().get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS).toString();
        File ufsFile = new File(rootUfsDir + testFilePath);
        ufsFile.delete();
        PrintWriter out = new PrintWriter(ufsFile);
        String newContent = "testfoobarshorterthantheoriginalfile";
        out.print(newContent);
        out.close();
        AlluxioURI uri = new AlluxioURI(testFilePath);
        URIStatus uriStatus = sFileSystem.getStatus(uri);
        long length = uriStatus.getLength();
        Assert.assertEquals((long)size, (long)length);
        int ret = sFsShell.run(new String[]{"cat", testFilePath});
        Assert.assertEquals((long)-1L, (long)ret);
        String errMsg = String.format("expected to be %s bytes, but only %s bytes are available", size, newContent.getBytes().length);
        Assert.assertTrue((boolean)this.mOutput.toString().contains(errMsg));
        URIStatus updatedUriStatus = sFileSystem.getStatus(new AlluxioURI(testFilePath));
        long updatedLength = updatedUriStatus.getLength();
        Assert.assertEquals((long)newContent.getBytes().length, (long)updatedLength);
        try (FileInStream tfis = sFileSystem.openFile(uri);){
            byte[] actual = new byte[newContent.getBytes().length];
            tfis.read(actual);
            Assert.assertArrayEquals((byte[])newContent.getBytes(), (byte[])actual);
        }
        ret = sFsShell.run(new String[]{"cat", testFilePath});
        Assert.assertEquals((long)0L, (long)ret);
    }
}

