/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.WritePType;
import alluxio.util.io.BufferUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="Jiacheng", comment="need to check if this command will still exist in Dora")
public final class ChecksumCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void checksum() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"checksum", "/testFile"});
        String str = this.mOutput.toString();
        String[] splitString = str.split("\\s+");
        byte[] data = BufferUtils.getIncreasingByteArray((int)10);
        try {
            String expectedMd5 = DigestUtils.md5Hex((byte[])data);
            Assert.assertEquals((Object)splitString[1], (Object)expectedMd5);
        }
        catch (Exception e) {
            Assert.fail((String)("md5cksum failure not expected: " + e.getMessage()));
        }
    }

    @Test
    public void checksumWildCard() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFileA", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir2/testFileB", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"checksum", "/testDir*/testFile*"});
        String str = this.mOutput.toString();
        String[] splitString = str.split("\\s+");
        byte[] data = BufferUtils.getIncreasingByteArray((int)10);
        try {
            String expectedMd5 = DigestUtils.md5Hex((byte[])data);
            Assert.assertEquals((Object)splitString[1], (Object)expectedMd5);
            Assert.assertEquals((Object)splitString[3], (Object)expectedMd5);
        }
        catch (Exception e) {
            Assert.fail((String)("md5cksum failure not expected: " + e.getMessage()));
        }
    }

    @Test
    public void checksumInvalidArgs() throws Exception {
        sFsShell.run(new String[]{"checksum", "/testFile"});
        String expected = ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/testFile"}) + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
        sFsShell.run(new String[]{"mkdir", "/testFolder"});
        int ret = sFsShell.run(new String[]{"checksum", "/testFolder"});
        Assert.assertEquals((long)-1L, (long)ret);
    }
}

