/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="Jiacheng", comment="need to check if this command will still exist in Dora")
public final class ChgrpCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void chgrp() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chgrp", "group1", "/testFile"});
        String group = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        sFsShell.run(new String[]{"chgrp", "group2", "/testFile"});
        group = sFileSystem.getStatus(new AlluxioURI("/testFile")).getGroup();
        Assert.assertEquals((Object)"group2", (Object)group);
    }

    @Test
    public void chgrpRecursive() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chgrp", "-R", "group1", "/testDir"});
        String group = sFileSystem.getStatus(new AlluxioURI("/testDir")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        sFsShell.run(new String[]{"chgrp", "-R", "group2", "/testDir"});
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getGroup();
        Assert.assertEquals((Object)"group2", (Object)group);
    }

    @Test
    public void chgrpWildcard() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/foo/testFile1", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/foo/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/bar/testFile3", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chgrp", "group1", "/testDir/*/testFile*"});
        String group = sFileSystem.getStatus(new AlluxioURI("/testDir/foo/testFile1")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/foo/testFile2")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/bar/testFile3")).getGroup();
        Assert.assertEquals((Object)"group1", (Object)group);
        sFsShell.run(new String[]{"chgrp", "group2", "/testDir/*/testFile*"});
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/foo/testFile1")).getGroup();
        Assert.assertEquals((Object)"group2", (Object)group);
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/foo/testFile2")).getGroup();
        Assert.assertEquals((Object)"group2", (Object)group);
        group = sFileSystem.getStatus(new AlluxioURI("/testDir/bar/testFile3")).getGroup();
        Assert.assertEquals((Object)"group2", (Object)group);
    }
}

