/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="Jiacheng", comment="need to check if this command will still exist in Dora")
public final class ChmodCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void chmod() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chmod", "777", "/testFile"});
        int permission = sFileSystem.getStatus(new AlluxioURI("/testFile")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        sFsShell.run(new String[]{"chmod", "755", "/testFile"});
        permission = sFileSystem.getStatus(new AlluxioURI("/testFile")).getMode();
        Assert.assertEquals((long)493L, (long)permission);
    }

    @Test
    public void chmodRecursively() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chmod", "-R", "777", "/testDir"});
        int permission = sFileSystem.getStatus(new AlluxioURI("/testDir")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        permission = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        sFsShell.run(new String[]{"chmod", "-R", "755", "/testDir"});
        permission = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile")).getMode();
        Assert.assertEquals((long)493L, (long)permission);
    }

    @Test
    public void chmodSymbolic() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chmod", "a=rwx", "/testFile"});
        int permission = sFileSystem.getStatus(new AlluxioURI("/testFile")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        sFsShell.run(new String[]{"chmod", "u=rwx,go=rx", "/testFile"});
        permission = sFileSystem.getStatus(new AlluxioURI("/testFile")).getMode();
        Assert.assertEquals((long)493L, (long)permission);
    }

    @Test
    public void chmodWildCard() throws IOException, AlluxioException {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir/testFile1", (WritePType)WritePType.MUST_CACHE, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir2/testFile2", (WritePType)WritePType.MUST_CACHE, (int)10);
        sFsShell.run(new String[]{"chmod", "a=rwx", "/testDir*/testFile*"});
        int permission = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile1")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        permission = sFileSystem.getStatus(new AlluxioURI("/testDir2/testFile2")).getMode();
        Assert.assertEquals((long)511L, (long)permission);
        sFsShell.run(new String[]{"chmod", "u=rwx,go=rx", "/testDir*/testFile*"});
        permission = sFileSystem.getStatus(new AlluxioURI("/testDir/testFile1")).getMode();
        Assert.assertEquals((long)493L, (long)permission);
        permission = sFileSystem.getStatus(new AlluxioURI("/testDir2/testFile2")).getMode();
        Assert.assertEquals((long)493L, (long)permission);
    }
}

