/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.AlluxioException;
import alluxio.grpc.WritePType;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="fix free command")
public final class FreeCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void freeNonPersistedFile() throws IOException, AlluxioException {
        String fileName = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.MUST_CACHE, (int)10);
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"free", fileName}));
        Assert.assertTrue((boolean)this.isInMemoryTest(fileName));
    }

    @Test
    public void freePinnedFile() throws IOException, AlluxioException {
        String fileName = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        sFsShell.run(new String[]{"pin", fileName});
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"free", fileName}));
        Assert.assertTrue((boolean)this.isInMemoryTest(fileName));
    }

    @Test
    public void freePinnedFileForced() throws IOException, AlluxioException {
        String fileName = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        sFsShell.run(new String[]{"pin", fileName});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"free", "-f", fileName}));
        Assert.assertFalse((boolean)this.isInMemoryTest(fileName));
    }

    @Test
    public void free() throws IOException, AlluxioException {
        String fileName = "/testFile";
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)fileName, (WritePType)WritePType.CACHE_THROUGH, (int)10);
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"free", fileName}));
        Assert.assertFalse((boolean)this.isInMemoryTest(fileName));
    }

    @Test
    public void freeWildCardNonPersistedFile() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem, WritePType.MUST_CACHE);
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"free", testDir + "/foo/*"}));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foo/foobar1"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foo/foobar2"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/bar/foobar3"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foobar4"));
    }

    @Test
    public void freeWildCardPinnedFile() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem, WritePType.CACHE_THROUGH);
        sFsShell.run(new String[]{"pin", testDir + "/foo/*"});
        Assert.assertEquals((long)-1L, (long)sFsShell.run(new String[]{"free", testDir + "/foo/*"}));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foo/foobar1"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foo/foobar2"));
    }

    @Test
    public void freeWildCardPinnedFileForced() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem, WritePType.CACHE_THROUGH);
        sFsShell.run(new String[]{"pin", testDir + "/foo/foobar1"});
        Assert.assertEquals((long)0L, (long)sFsShell.run(new String[]{"free", "-f", testDir + "/foo/*"}));
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/foo/foobar1"));
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/foo/foobar2"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/bar/foobar3"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foobar4"));
    }

    @Test
    public void freeWildCard() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem, WritePType.CACHE_THROUGH);
        int ret = sFsShell.run(new String[]{"free", testDir + "/foo/*"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/foo/foobar1"));
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/foo/foobar2"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/bar/foobar3"));
        Assert.assertTrue((boolean)this.isInMemoryTest(testDir + "/foobar4"));
        ret = sFsShell.run(new String[]{"free", testDir + "/*/"});
        Assert.assertEquals((long)0L, (long)ret);
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/bar/foobar3"));
        Assert.assertFalse((boolean)this.isInMemoryTest(testDir + "/foobar4"));
    }
}

