/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.WritePType;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="adapt the command to the new arch")
public final class NeedsSyncCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void needsSyncDir() throws IOException, AlluxioException {
        CreateFilePOptions createOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        AlluxioURI dir = new AlluxioURI("/dir");
        sFileSystem.createDirectory(dir);
        AlluxioURI file1 = dir.join("file1");
        sFileSystem.createFile(file1, createOptions).close();
        Assert.assertEquals((Object)ImmutableList.of((Object)file1.getPath()), sFileSystem.listStatus(dir).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        AlluxioURI file2 = dir.join("file2");
        String ufsPath = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.createFile(Paths.get(ufsPath, file2.getPath()), new FileAttribute[0]);
        Assert.assertEquals((Object)ImmutableList.of((Object)file1.getPath()), sFileSystem.listStatus(dir).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        sFsShell.run(new String[]{"needsSync", dir.getPath()});
        Assert.assertEquals((Object)ImmutableList.of((Object)file1.getPath(), (Object)file2.getPath()), sFileSystem.listStatus(dir).stream().map(URIStatus::getPath).collect(Collectors.toList()));
    }

    @Test
    public void needsSyncFile() throws IOException, AlluxioException {
        CreateFilePOptions createOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        AlluxioURI dir = new AlluxioURI("/dir");
        sFileSystem.createDirectory(dir);
        AlluxioURI file1 = dir.join("file1");
        String fileContents = "some bytes";
        try (FileOutStream f = sFileSystem.createFile(file1, createOptions);){
            f.write(fileContents.getBytes());
        }
        Assert.assertEquals((Object)fileContents, (Object)new String(IOUtils.toByteArray((InputStream)sFileSystem.openFile(file1))));
        String newFileContents = "a new file write that is longer";
        String ufsPath = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.write(Paths.get(ufsPath, file1.getPath()), newFileContents.getBytes(), new OpenOption[0]);
        Assert.assertEquals((Object)fileContents, (Object)new String(IOUtils.toByteArray((InputStream)sFileSystem.openFile(file1))));
        sFsShell.run(new String[]{"needsSync", file1.getPath()});
        Assert.assertEquals((Object)newFileContents, (Object)new String(IOUtils.toByteArray((InputStream)sFileSystem.openFile(file1))));
    }

    @Test
    public void needsSyncWithWildcard() throws IOException, AlluxioException {
        CreateFilePOptions createOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).build();
        ListStatusPOptions listStatusOptions = ListStatusPOptions.newBuilder().setRecursive(true).build();
        CreateDirectoryPOptions createDirectoryOptions = CreateDirectoryPOptions.newBuilder().setRecursive(true).build();
        AlluxioURI dir2 = new AlluxioURI("/dir1/dir2");
        sFileSystem.createDirectory(dir2, createDirectoryOptions);
        AlluxioURI file1 = dir2.join("file1");
        sFileSystem.createFile(file1, createOptions).close();
        ImmutableList listing = ImmutableList.of((Object)file1.getPath());
        Assert.assertEquals((Object)listing, sFileSystem.listStatus(dir2, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        AlluxioURI file2 = dir2.join("file2");
        String ufsPath = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.createFile(Paths.get(ufsPath, file2.getPath()), new FileAttribute[0]);
        Assert.assertEquals((Object)listing, sFileSystem.listStatus(dir2, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        AlluxioURI dir3 = new AlluxioURI("/dir1/dir3");
        sFileSystem.createDirectory(dir3, createDirectoryOptions);
        AlluxioURI file3 = dir3.join("file3");
        sFileSystem.createFile(file3, createOptions).close();
        listing = ImmutableList.of((Object)file3.getPath());
        Assert.assertEquals((Object)listing, sFileSystem.listStatus(dir3, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        AlluxioURI file4 = dir3.join("file4");
        Files.createFile(Paths.get(ufsPath, file4.getPath()), new FileAttribute[0]);
        Assert.assertEquals((Object)listing, sFileSystem.listStatus(dir3, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        sFsShell.run(new String[]{"needsSync", "/dir*/*/file*"});
        Assert.assertEquals((Object)ImmutableList.of((Object)file1.getPath(), (Object)file2.getPath()), sFileSystem.listStatus(dir2, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableList.of((Object)file3.getPath(), (Object)file4.getPath()), sFileSystem.listStatus(dir3, listStatusOptions).stream().map(URIStatus::getPath).collect(Collectors.toList()));
    }
}

