/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.grpc.WritePType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jianjian", comment="fix tests or demise with the command")
public final class OldLoadCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void loadDir() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileA", (WritePType)WritePType.THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testRoot/testFileB", (WritePType)WritePType.MUST_CACHE, (int)10);
        AlluxioURI uriA = new AlluxioURI("/testRoot/testFileA");
        AlluxioURI uriB = new AlluxioURI("/testRoot/testFileB");
        URIStatus statusA = sFileSystem.getStatus(uriA);
        URIStatus statusB = sFileSystem.getStatus(uriB);
        Assert.assertFalse((statusA.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        Assert.assertTrue((statusB.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        sFsShell.run(new String[]{"load", "/testRoot"});
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriA, (int)100);
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uriB, (int)100);
    }

    @Test
    public void loadFile() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.THROUGH, (int)10);
        AlluxioURI uri = new AlluxioURI("/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertFalse((status.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        sFsShell.run(new String[]{"load", "/testFile"});
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uri, (int)100);
    }

    @Test
    public void loadFileWithLocalOption() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile", (WritePType)WritePType.CACHE_THROUGH, (int)10);
        AlluxioURI uri = new AlluxioURI("/testFile");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertTrue((status.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        sFsShell.run(new String[]{"load", "--local", "/testFile"});
        Assert.assertEquals((Object)"/testFile loaded\n", (Object)this.mOutput.toString());
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testFile2", (WritePType)WritePType.THROUGH, (int)10);
        uri = new AlluxioURI("/testFile2");
        status = sFileSystem.getStatus(uri);
        Assert.assertFalse((status.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        sFsShell.run(new String[]{"load", "--local", "/testFile2"});
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uri, (int)100);
    }

    @Test
    public void loadFileWithWildcard() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir1/testFile1", (WritePType)WritePType.THROUGH, (int)10);
        FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (String)"/testDir2/testFile2", (WritePType)WritePType.THROUGH, (int)10);
        AlluxioURI uri = new AlluxioURI("/testDir1/testFile1");
        URIStatus status = sFileSystem.getStatus(uri);
        Assert.assertFalse((status.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        uri = new AlluxioURI("/testDir2/testFile2");
        status = sFileSystem.getStatus(uri);
        Assert.assertFalse((status.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        sFsShell.run(new String[]{"load", "/*/testFile*"});
        uri = new AlluxioURI("/testDir1/testFile1");
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uri, (int)100);
        uri = new AlluxioURI("/testDir2/testFile2");
        FileSystemUtils.waitForAlluxioPercentage((FileSystem)sFileSystem, (AlluxioURI)uri, (int)100);
    }
}

