/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="fix rm command")
public final class RmCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void rmNotExistingDir() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder"}));
        sFsShell.run(new String[]{"rm", "/testFolder"});
        toCompare.append("/testFolder is a directory, to remove it, please use \"rm -R/-r/--recursive <path>\"\n");
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
    }

    @Test
    public void rmNotExistingFile() throws IOException {
        sFsShell.run(new String[]{"rm", "/testFile"});
        String expected = ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/testFile"}) + "\n";
        Assert.assertEquals((Object)expected, (Object)this.mOutput.toString());
    }

    @Test
    public void rm() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder1/testFolder2"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder1/testFolder2"}));
        sFsShell.run(new String[]{"touch", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"touch", "/testFolder1/testFolder2/testFile2"}));
        AlluxioURI testFolder1 = new AlluxioURI("/testFolder1");
        AlluxioURI testFolder2 = new AlluxioURI("/testFolder1/testFolder2");
        AlluxioURI testFile2 = new AlluxioURI("/testFolder1/testFolder2/testFile2");
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertTrue((boolean)this.fileExists(testFile2));
        sFsShell.run(new String[]{"rm", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"rm", "/testFolder1/testFolder2/testFile2"}));
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertFalse((boolean)this.fileExists(testFile2));
    }

    @Test
    public void rmWildCard() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        sFsShell.run(new String[]{"rm", testDir + "/foo/foo*"});
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foo/foobar1")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/bar/foobar3")));
        sFsShell.run(new String[]{"rm", testDir + "/*"});
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foobar4")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/foo")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/bar")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/bar/foobar3")));
    }

    @Test
    public void rmr() throws IOException {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder1/testFolder2"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder1/testFolder2"}));
        sFsShell.run(new String[]{"touch", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"touch", "/testFolder1/testFolder2/testFile2"}));
        AlluxioURI testFolder1 = new AlluxioURI("/testFolder1");
        AlluxioURI testFolder2 = new AlluxioURI("/testFolder1/testFolder2");
        AlluxioURI testFile2 = new AlluxioURI("/testFolder1/testFolder2/testFile2");
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertTrue((boolean)this.fileExists(testFile2));
        sFsShell.run(new String[]{"rm", "-R", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"rm", "/testFolder1/testFolder2/testFile2"}));
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertFalse((boolean)this.fileExists(testFile2));
        sFsShell.run(new String[]{"rm", "-R", "/testFolder1"});
        toCompare.append(this.getCommandOutput(new String[]{"rmr", "/testFolder1"}));
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
        Assert.assertFalse((boolean)this.fileExists(testFolder1));
        Assert.assertFalse((boolean)this.fileExists(testFolder2));
        Assert.assertFalse((boolean)this.fileExists(testFile2));
    }

    @Test
    public void rmrWildCard() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        sFsShell.run(new String[]{"rm", "-R", testDir + "/foo/foo*"});
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foo/foobar1")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foo/foobar2")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/foo")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/bar/foobar3")));
        sFsShell.run(new String[]{"rm", "-R", testDir + "/ba*"});
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/bar")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/bar/foobar3")));
        Assert.assertTrue((boolean)this.fileExists(new AlluxioURI(testDir + "/foobar4")));
        sFsShell.run(new String[]{"rm", "-R", testDir + "/*"});
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/bar")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foo")));
        Assert.assertFalse((boolean)this.fileExists(new AlluxioURI(testDir + "/foobar4")));
    }

    @Test
    public void rmSyncDirNextTime() {
        StringBuilder toCompare = new StringBuilder();
        sFsShell.run(new String[]{"mkdir", "/testFolder1/testFolder2"});
        toCompare.append(this.getCommandOutput(new String[]{"mkdir", "/testFolder1/testFolder2"}));
        sFsShell.run(new String[]{"touch", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"touch", "/testFolder1/testFolder2/testFile2"}));
        AlluxioURI testFolder1 = new AlluxioURI("/testFolder1");
        AlluxioURI testFolder2 = new AlluxioURI("/testFolder1/testFolder2");
        AlluxioURI testFile2 = new AlluxioURI("/testFolder1/testFolder2/testFile2");
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertTrue((boolean)this.fileExists(testFile2));
        sFsShell.run(new String[]{"rm", "--alluxioOnly", "-s", "true", "/testFolder1/testFolder2/testFile2"});
        toCompare.append(this.getCommandOutput(new String[]{"rm", "/testFolder1/testFolder2/testFile2"}).replace("\n", "") + " only from Alluxio space\n");
        Assert.assertEquals((Object)toCompare.toString(), (Object)this.mOutput.toString());
        Assert.assertTrue((boolean)this.fileExists(testFolder1));
        Assert.assertTrue((boolean)this.fileExists(testFolder2));
        Assert.assertFalse((boolean)this.fileExistsInAlluxio(testFile2));
        Assert.assertTrue((boolean)this.fileExists(testFile2));
        Assert.assertTrue((boolean)this.fileExistsInAlluxio(testFile2));
    }
}

