/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fs.command;

import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fs.AbstractFileSystemShellTest;
import alluxio.client.cli.fs.FileSystemShellUtilsTest;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="adapt this command to the new arch")
public final class StatCommandIntegrationTest
extends AbstractFileSystemShellTest {
    @Test
    public void statFileNotExist() throws IOException {
        int ret = sFsShell.run(new String[]{"stat", "/NotExistFile"});
        Assert.assertEquals((Object)(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{"/NotExistFile"}) + "\n"), (Object)this.mOutput.toString());
        Assert.assertEquals((long)-1L, (long)ret);
    }

    @Test
    public void statFileWildCard() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        sFsShell.run(new String[]{"stat", testDir + "/*"});
        String res1 = this.mOutput.toString();
        Assert.assertTrue((boolean)res1.contains(testDir + "/foo"));
        Assert.assertTrue((boolean)res1.contains(testDir + "/bar"));
        Assert.assertTrue((boolean)res1.contains(testDir + "/foobar4"));
        Assert.assertFalse((boolean)res1.contains(testDir + "/foo/foobar1"));
        Assert.assertFalse((boolean)res1.contains(testDir + "/bar/foobar3"));
        sFsShell.run(new String[]{"stat", testDir + "/*/foo*"});
        String res2 = this.mOutput.toString();
        res2 = res2.replace(res1, "");
        Assert.assertTrue((boolean)res2.contains(testDir + "/foo/foobar1"));
        Assert.assertTrue((boolean)res2.contains(testDir + "/foo/foobar2"));
        Assert.assertTrue((boolean)res2.contains(testDir + "/bar/foobar3"));
        Assert.assertFalse((boolean)res2.contains(testDir + "/foobar4"));
    }

    @Test
    public void statDirectoryWildCard() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        sFsShell.run(new String[]{"stat", testDir + "/*"});
        String res1 = this.mOutput.toString();
        Assert.assertTrue((boolean)res1.contains(testDir + "/foo"));
        Assert.assertTrue((boolean)res1.contains(testDir + "/bar"));
        Assert.assertTrue((boolean)res1.contains(testDir + "/foobar4"));
        Assert.assertFalse((boolean)res1.contains(testDir + "/foo/foobar1"));
        Assert.assertFalse((boolean)res1.contains(testDir + "/bar/foobar3"));
        sFsShell.run(new String[]{"stat", testDir + "/*/foo*"});
        String res2 = this.mOutput.toString();
        res2 = res2.replace(res1, "");
        Assert.assertTrue((boolean)res2.contains(testDir + "/foo/foobar1"));
        Assert.assertTrue((boolean)res2.contains(testDir + "/foo/foobar2"));
        Assert.assertTrue((boolean)res2.contains(testDir + "/bar/foobar3"));
        Assert.assertFalse((boolean)res2.contains(testDir + "/foobar4"));
    }

    @Test
    public void statFileFormat() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        String format = "%N-%z-%b-%u-%g-%Y";
        sFsShell.run(new String[]{"stat", "-f", format, testDir + "/foo/foobar1"});
        String res1 = this.mOutput.toString();
        Assert.assertTrue((boolean)res1.startsWith("foobar1-10-1-"));
        format = "%N-%z-%b-%u-%g-%y";
        sFsShell.run(new String[]{"stat", "-f", format, testDir + "/foo/foobar1"});
        String res2 = this.mOutput.toString();
        res2 = res2.replace(res1, "");
        Assert.assertTrue((boolean)res2.startsWith("foobar1-10-1-"));
    }

    @Test
    public void statDirectoryFormat() throws IOException, AlluxioException {
        String testDir = FileSystemShellUtilsTest.resetFileHierarchy(sFileSystem);
        String format = "%N-%z-%b-%Y-%u-%g";
        sFsShell.run(new String[]{"stat", "-f", format, testDir + "/foo"});
        String res1 = this.mOutput.toString();
        Assert.assertTrue((boolean)res1.startsWith("foo-NA-NA-"));
        format = "%N-%z-%b-%y-%u-%g";
        sFsShell.run(new String[]{"stat", "-f", format, testDir + "/foo"});
        String res2 = this.mOutput.toString();
        res2 = res2.replace(res1, "");
        Assert.assertTrue((boolean)res2.startsWith("foo-NA-NA-"));
    }
}

