/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.master.MasterContext;
import alluxio.master.MasterProcess;
import alluxio.master.StateLockManager;
import alluxio.master.StateLockOptions;
import alluxio.resource.LockResource;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

@LocalAlluxioClusterResource.ServerConfig(confParams={"alluxio.master.backup.directory", "${alluxio.work.dir}/backups", "alluxio.master.shell.backup.state.lock.try.duration", "3s", "alluxio.master.shell.backup.state.lock.timeout", "3s", "alluxio.master.shell.backup.state.lock.grace.mode", "TIMEOUT"})
@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="backup no longer exists")
public final class BackupCommandStateLockingIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void timeoutWhenStateLockAcquired() throws Exception {
        MasterProcess masterProcess = (MasterProcess)Whitebox.getInternalState((Object)this.mLocalAlluxioCluster.getLocalAlluxioMaster(), (String)"mMasterProcess");
        MasterContext masterCtx = (MasterContext)Whitebox.getInternalState((Object)masterProcess, (String)"mContext");
        StateLockManager stateLockManager = masterCtx.getStateLockManager();
        try (LockResource lr = stateLockManager.lockExclusive(StateLockOptions.defaults());){
            Path dir = Paths.get(Configuration.getString((PropertyKey)PropertyKey.MASTER_BACKUP_DIRECTORY), new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Assert.assertEquals((long)0L, (long)Files.list(dir).count());
            int errCode = this.mFsAdminShell.run(new String[]{"backup"});
            Assert.assertTrue((boolean)this.mOutput.toString().contains(ExceptionMessage.STATE_LOCK_TIMED_OUT.getMessage(new Object[]{3000})));
            Assert.assertNotEquals((long)0L, (long)errCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void takeBackupDuringExclusiveOnlyPhase() throws Exception {
        MasterProcess masterProcess = (MasterProcess)Whitebox.getInternalState((Object)this.mLocalAlluxioCluster.getLocalAlluxioMaster(), (String)"mMasterProcess");
        MasterContext masterCtx = (MasterContext)Whitebox.getInternalState((Object)masterProcess, (String)"mContext");
        StateLockManager stateLockManager = masterCtx.getStateLockManager();
        long exclusiveOnlyDurationMs = 30000L;
        Whitebox.setInternalState((Object)stateLockManager, (String)"mExclusiveOnlyDeadlineMs", (Object)(System.currentTimeMillis() + exclusiveOnlyDurationMs));
        try {
            this.mException.expect(AlluxioException.class);
            this.mLocalAlluxioCluster.getClient().getStatus(new AlluxioURI("/"));
            Path dir = Paths.get(Configuration.getString((PropertyKey)PropertyKey.MASTER_BACKUP_DIRECTORY), new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Assert.assertEquals((long)0L, (long)Files.list(dir).count());
            int errCode = this.mFsAdminShell.run(new String[]{"backup"});
            Assert.assertEquals((Object)"", (Object)this.mErrOutput.toString());
            Assert.assertEquals((long)0L, (long)errCode);
            Assert.assertEquals((long)1L, (long)Files.list(dir).count());
        }
        finally {
            Whitebox.setInternalState((Object)stateLockManager, (String)"mExclusiveOnlyDeadlineMs", (Object)-1);
        }
    }
}

