/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.cli.fsadmin.command;

import alluxio.cli.fsadmin.command.UpdateConfCommand;
import alluxio.client.cli.fsadmin.AbstractFsAdminShellTest;
import org.junit.Assert;
import org.junit.Test;

public final class UpdateConfIntegrationTest
extends AbstractFsAdminShellTest {
    @Test
    public void unknownOption() {
        int ret = this.mFsAdminShell.run(new String[]{"updateConf", "--unknown"});
        Assert.assertEquals((long)-1L, (long)ret);
        String output = this.mOutput.toString();
        Assert.assertEquals((Object)UpdateConfCommand.description(), (Object)this.lastLine(output));
    }

    @Test
    public void updateUnknownKey() {
        int ret = this.mFsAdminShell.run(new String[]{"updateConf", "unknown-key=unknown-value"});
        Assert.assertEquals((long)-2L, (long)ret);
        ret = this.mFsAdminShell.run(new String[]{"updateConf", "unknown-key"});
        Assert.assertEquals((long)-1L, (long)ret);
        ret = this.mFsAdminShell.run(new String[]{"updateConf", "unknown-key=1=2"});
        Assert.assertEquals((long)-3L, (long)ret);
    }

    @Test
    public void updateNormal() {
        int ret = this.mFsAdminShell.run(new String[]{"updateConf", "alluxio.master.worker.timeout=4min"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    @Test
    public void updateNonDynamicKey() {
        int ret = this.mFsAdminShell.run(new String[]{"updateConf", "alluxio.security.authorization.permission.enabled=false"});
        Assert.assertEquals((long)-2L, (long)ret);
    }

    private String lastLine(String output) {
        String[] lines = output.split("\n");
        if (lines.length > 0) {
            return lines[lines.length - 1];
        }
        return "";
    }
}

