/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.TestLoggerRule;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.resource.CloseableResource;
import alluxio.security.user.TestUserState;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.wire.WorkerNetAddress;
import io.netty.util.ResourceLeakDetector;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.Subject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public final class BlockWorkerClientCloseIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().build();
    @Rule
    public TestLoggerRule mLogger = new TestLoggerRule();
    private WorkerNetAddress mWorkerNetAddress;
    private FileSystemContext mFsContext;

    @Before
    public void before() throws Exception {
        this.mWorkerNetAddress = this.mClusterResource.get().getWorkerAddress();
        this.mFsContext = FileSystemContext.create((Subject)new TestUserState("test", Configuration.global()).getSubject(), (AlluxioConfiguration)Configuration.global());
    }

    @After
    public void after() throws Exception {
        this.mFsContext.close();
    }

    @Test
    public void close() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            CloseableResource client = this.mFsContext.acquireBlockWorkerClient(this.mWorkerNetAddress);
            Assert.assertFalse((boolean)((BlockWorkerClient)client.get()).isShutdown());
            ((BlockWorkerClient)client.get()).close();
            Assert.assertTrue((boolean)((BlockWorkerClient)client.get()).isShutdown());
            client.close();
        }
    }

    @Ignore
    @Test
    public void testLeakTracker() throws Exception {
        CloseableResource closeableResource;
        int i;
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.PARANOID);
        for (i = 0; i < 5; ++i) {
            closeableResource = this.mFsContext.acquireBlockWorkerClient(this.mWorkerNetAddress);
        }
        for (i = 0; i < 10; ++i) {
            byte[] mem = new byte[0x40000000];
            if (mem[0] == 122) continue;
            int n = ThreadLocalRandom.current().nextInt(0x100000);
            mem[n] = (byte)(mem[n] + 1);
        }
        for (i = 0; i < 5; ++i) {
            closeableResource = this.mFsContext.acquireBlockWorkerClient(this.mWorkerNetAddress);
        }
        System.gc();
        Assert.assertTrue((boolean)this.mLogger.wasLogged("DefaultBlockWorkerClient\\.close\\(\\) was not called before resource is garbage-collected"));
    }
}

