/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.client.WriteType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.master.journal.JournalType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.gaul.s3proxy.junit.S3ProxyRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class DoraFileSystemIntegrationTest
extends BaseIntegrationTest {
    @Rule
    public S3ProxyRule mS3Proxy = S3ProxyRule.builder().withBlobStoreProvider("transient").withPort(8001).withCredentials("_", "_").build();
    LocalAlluxioClusterResource.Builder mLocalAlluxioClusterResourceBuilder = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_PERSISTENCE_CHECKER_INTERVAL_MS, "10ms").setProperty(PropertyKey.MASTER_PERSISTENCE_SCHEDULER_INTERVAL_MS, "10ms").setProperty(PropertyKey.JOB_MASTER_WORKER_HEARTBEAT_INTERVAL, "200ms").setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x1000000).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, Long.MAX_VALUE).setProperty(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.CACHE_THROUGH).setProperty(PropertyKey.USER_FILE_RESERVED_BYTES, 0x800000).setProperty(PropertyKey.CONF_DYNAMIC_UPDATE_ENABLED, true).setProperty(PropertyKey.WORKER_BLOCK_STORE_TYPE, "PAGE").setProperty(PropertyKey.WORKER_PAGE_STORE_PAGE_SIZE, 1024).setProperty(PropertyKey.WORKER_PAGE_STORE_SIZES, "1GB").setProperty(PropertyKey.MASTER_JOURNAL_TYPE, JournalType.NOOP).setProperty(PropertyKey.UNDERFS_S3_ENDPOINT, "localhost:8001").setProperty(PropertyKey.UNDERFS_S3_ENDPOINT_REGION, "us-west-2").setProperty(PropertyKey.UNDERFS_S3_DISABLE_DNS_BUCKETS, true).setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "s3://test-bucket").setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, "s3://test-bucket").setProperty(PropertyKey.WORKER_HTTP_SERVER_ENABLED, false).setProperty(PropertyKey.S3A_ACCESS_KEY, this.mS3Proxy.getAccessKey()).setProperty(PropertyKey.S3A_SECRET_KEY, this.mS3Proxy.getSecretKey()).setNumWorkers(2).setStartCluster(false);
    private static final String TEST_BUCKET = "test-bucket";
    private static final String TEST_FILE = "test-file";
    private static final AlluxioURI TEST_FILE_URI = new AlluxioURI("/test-file");
    private static final String TEST_CONTENT = "test-content";
    private static final String UPDATED_TEST_CONTENT = "updated-test-content";
    private FileSystem mFileSystem = null;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private AmazonS3 mS3Client = null;

    @Before
    public void before() throws Exception {
    }

    private void startCluster(LocalAlluxioClusterResource cluster) throws Exception {
        cluster.start();
        this.mFileSystem = cluster.get().getClient();
        if (this.mS3Client == null) {
            this.mS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.mS3Proxy.getAccessKey(), this.mS3Proxy.getSecretKey())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.mS3Proxy.getUri().toString(), Regions.US_WEST_2.getName()))).build();
            this.mS3Client.createBucket(TEST_BUCKET);
        }
    }

    private void stopCluster(LocalAlluxioClusterResource cluster) throws Exception {
        this.mFileSystem = null;
        cluster.stop();
    }

    private void writeThenDeleteFromUfs(boolean clientWriteToUFS) throws IOException, AlluxioException, Exception {
        this.mLocalAlluxioClusterResourceBuilder.setProperty(PropertyKey.CLIENT_WRITE_TO_UFS_ENABLED, clientWriteToUFS);
        LocalAlluxioClusterResource clusterResource = this.mLocalAlluxioClusterResourceBuilder.build();
        this.startCluster(clusterResource);
        FileOutStream fos = this.mFileSystem.createFile(TEST_FILE_URI, CreateFilePOptions.newBuilder().setOverwrite(true).build());
        fos.write(TEST_CONTENT.getBytes());
        fos.close();
        this.mS3Client.deleteObject(TEST_BUCKET, TEST_FILE);
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(TEST_FILE_URI, GetStatusPOptions.newBuilder().setCommonOptions(this.optionNoSync()).build()));
        try (FileInStream fis = this.mFileSystem.openFile(TEST_FILE_URI, OpenFilePOptions.newBuilder().setCommonOptions(this.optionNoSync()).build());){
            String content = IOUtils.toString((InputStream)fis);
            Assert.assertEquals((Object)TEST_CONTENT, (Object)content);
        }
        Assert.assertThrows(FileDoesNotExistException.class, () -> this.mFileSystem.getStatus(TEST_FILE_URI, GetStatusPOptions.newBuilder().setCommonOptions(this.optionSync()).build()));
        Assert.assertThrows(FileDoesNotExistException.class, () -> this.mFileSystem.getStatus(TEST_FILE_URI, GetStatusPOptions.newBuilder().setCommonOptions(this.optionNoSync()).build()));
        this.stopCluster(clusterResource);
    }

    private void writeThenUpdateFromUfs(boolean clientWriteToUFS) throws IOException, AlluxioException, Exception {
        String content;
        this.mLocalAlluxioClusterResourceBuilder.setProperty(PropertyKey.CLIENT_WRITE_TO_UFS_ENABLED, clientWriteToUFS);
        LocalAlluxioClusterResource clusterResource = this.mLocalAlluxioClusterResourceBuilder.build();
        this.startCluster(clusterResource);
        FileOutStream fos = this.mFileSystem.createFile(TEST_FILE_URI, CreateFilePOptions.newBuilder().setOverwrite(true).build());
        fos.write(TEST_CONTENT.getBytes());
        fos.close();
        this.mS3Client.putObject(TEST_BUCKET, TEST_FILE, UPDATED_TEST_CONTENT);
        Assert.assertNotNull((Object)this.mFileSystem.getStatus(TEST_FILE_URI, GetStatusPOptions.newBuilder().setCommonOptions(this.optionNoSync()).build()));
        try (FileInStream fis = this.mFileSystem.openFile(TEST_FILE_URI, OpenFilePOptions.newBuilder().setCommonOptions(this.optionNoSync()).build());){
            content = IOUtils.toString((InputStream)fis);
            Assert.assertEquals((Object)TEST_CONTENT, (Object)content);
        }
        this.mFileSystem.getStatus(TEST_FILE_URI, GetStatusPOptions.newBuilder().setCommonOptions(this.optionSync()).build());
        fis = this.mFileSystem.openFile(TEST_FILE_URI, OpenFilePOptions.newBuilder().setCommonOptions(this.optionNoSync()).build());
        var5_5 = null;
        try {
            content = IOUtils.toString((InputStream)fis);
            Assert.assertEquals((Object)UPDATED_TEST_CONTENT, (Object)content);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (var5_5 != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        this.stopCluster(clusterResource);
    }

    private FileSystemMasterCommonPOptions optionNoSync() {
        return FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(-1L).build();
    }

    private FileSystemMasterCommonPOptions optionSync() {
        return FileSystemMasterCommonPOptions.newBuilder().setSyncIntervalMs(0L).build();
    }

    @Test
    public void testWriteThenDeleteFromUfs() throws Exception {
        this.writeThenDeleteFromUfs(true);
        this.writeThenDeleteFromUfs(false);
    }

    @Test
    public void testWriteThenUpdateFromUfs() throws Exception {
        this.writeThenUpdateFromUfs(true);
        this.writeThenUpdateFromUfs(false);
    }
}

