/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.file.ConfigHashSync;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemContextReinitializer;
import alluxio.client.meta.RetryHandlingMetaMasterConfigClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.resource.CloseableResource;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public final class FileSystemContextReinitIntegrationTest
extends BaseIntegrationTest {
    private static final AlluxioURI PATH_TO_UPDATE = new AlluxioURI("/path/to/update");
    private static final PropertyKey KEY_TO_UPDATE = PropertyKey.USER_FILE_READ_TYPE_DEFAULT;
    private static final ReadType UPDATED_VALUE = ReadType.NO_CACHE;
    private FileSystemContext mContext;
    private String mClusterConfHash;
    private String mPathConfHash;
    private ConfigHashSync mExecutor;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();

    @Before
    public void before() throws Exception {
        this.mContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        this.mContext.getClientContext().loadConf(this.mContext.getMasterAddress(), true, true);
        this.updateHash();
        FileSystemContextReinitializer reinit = (FileSystemContextReinitializer)Whitebox.getInternalState((Object)this.mContext, (String)"mReinitializer");
        this.mExecutor = (ConfigHashSync)Whitebox.getInternalState((Object)reinit, (String)"mExecutor");
    }

    @Test
    public void noConfUpdateAndNoRestart() throws Exception {
        this.triggerAndWaitSync();
        this.checkHash(false, false);
    }

    @Test
    public void restartWithoutConfUpdate() throws Exception {
        this.restartMasters();
        this.triggerAndWaitSync();
        this.checkHash(false, false);
    }

    @Test
    public void blockWorkerClientReinit() throws Exception {
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        try (CloseableResource client = fsContext.acquireBlockWorkerClient(this.mLocalAlluxioClusterResource.get().getWorkerAddress());){
            fsContext.reinit(true, true);
            fsContext.acquireBlockWorkerClient(this.mLocalAlluxioClusterResource.get().getWorkerAddress()).close();
        }
    }

    private void triggerAndWaitSync() throws Exception {
        this.mExecutor.heartbeat(Long.MAX_VALUE);
    }

    private void restartMasters() throws Exception {
        this.mLocalAlluxioClusterResource.get().stopMasters();
        this.mLocalAlluxioClusterResource.get().startMasters();
    }

    private void updateClusterConf() throws Exception {
        this.mLocalAlluxioClusterResource.get().stopMasters();
        Configuration.set((PropertyKey)KEY_TO_UPDATE, (Object)UPDATED_VALUE);
        this.mLocalAlluxioClusterResource.get().startMasters();
    }

    private void updatePathConf() throws Exception {
        RetryHandlingMetaMasterConfigClient client = new RetryHandlingMetaMasterConfigClient(MasterClientContext.newBuilder((ClientContext)this.mContext.getClientContext()).build());
        client.setPathConfiguration(PATH_TO_UPDATE, KEY_TO_UPDATE, UPDATED_VALUE.name());
    }

    private void checkClusterConfBeforeUpdate() {
        Assert.assertNotEquals((Object)UPDATED_VALUE, (Object)this.mContext.getClientContext().getClusterConf().get(KEY_TO_UPDATE));
    }

    private void checkClusterConfAfterUpdate() {
        Assert.assertEquals((Object)UPDATED_VALUE, (Object)this.mContext.getClientContext().getClusterConf().get(KEY_TO_UPDATE));
    }

    private void checkPathConfBeforeUpdate() {
        Assert.assertFalse((boolean)this.mContext.getClientContext().getPathConf().getConfiguration(PATH_TO_UPDATE, KEY_TO_UPDATE).isPresent());
    }

    private void checkPathConfAfterUpdate() {
        Assert.assertEquals((Object)UPDATED_VALUE, (Object)((AlluxioConfiguration)this.mContext.getClientContext().getPathConf().getConfiguration(PATH_TO_UPDATE, KEY_TO_UPDATE).get()).get(KEY_TO_UPDATE));
    }

    private void checkHash(boolean clusterConfHashUpdated, boolean pathConfHashUpdated) {
        if (clusterConfHashUpdated) {
            Assert.assertNotEquals((Object)this.mClusterConfHash, (Object)this.mContext.getClientContext().getClusterConfHash());
        } else {
            Assert.assertEquals((Object)this.mClusterConfHash, (Object)this.mContext.getClientContext().getClusterConfHash());
        }
        if (pathConfHashUpdated) {
            Assert.assertNotEquals((Object)this.mPathConfHash, (Object)this.mContext.getClientContext().getPathConfHash());
        } else {
            Assert.assertEquals((Object)this.mPathConfHash, (Object)this.mContext.getClientContext().getPathConfHash());
        }
    }

    private void updateHash() {
        this.mClusterConfHash = this.mContext.getClientContext().getClusterConfHash();
        this.mPathConfHash = this.mContext.getClientContext().getPathConfHash();
    }
}

