/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.WriteType;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AccessControlException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.status.FailedPreconditionException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.master.MasterClientContext;
import alluxio.master.block.BlockMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.contexts.CompleteFileContext;
import alluxio.master.file.contexts.CreateDirectoryContext;
import alluxio.master.file.contexts.CreateFileContext;
import alluxio.master.file.contexts.DeleteContext;
import alluxio.master.file.contexts.FreeContext;
import alluxio.master.file.contexts.ListStatusContext;
import alluxio.master.file.contexts.RenameContext;
import alluxio.master.file.contexts.SetAttributeContext;
import alluxio.master.file.meta.TtlIntervalRule;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.master.FsMasterResource;
import alluxio.testutils.master.MasterTestUtils;
import alluxio.underfs.UfsMode;
import alluxio.util.CommonUtils;
import alluxio.util.ShellUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.FileUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.REMOVE, owner="jiacheng", comment="the FSM does not exist in dora")
public class FileSystemMasterIntegrationTest
extends BaseIntegrationTest {
    private static final int DEPTH = 6;
    private static final int FILES_PER_NODE = 4;
    private static final int CONCURRENCY_DEPTH = 3;
    private static final AlluxioURI ROOT_PATH = new AlluxioURI("/root");
    private static final AlluxioURI ROOT_PATH2 = new AlluxioURI("/root2");
    private static final long TEST_TIME_MS = Long.MAX_VALUE;
    private static final long TTL_CHECKER_INTERVAL_MS = 100L;
    private static final String TEST_USER = "test";
    @ClassRule
    public static ManuallyScheduleHeartbeat sManuallySchedule = new ManuallyScheduleHeartbeat(new String[]{"Master TTL Check"});
    @ClassRule
    public static TtlIntervalRule sTtlIntervalRule = new TtlIntervalRule(100L);
    @Rule
    public Timeout mGlobalTimeout = Timeout.seconds((long)60L);
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_METRICS_COLLECTION_ENABLED, false).setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, 100L).setProperty(PropertyKey.WORKER_RAMDISK_SIZE, "10mb").setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, "1kb").setProperty(PropertyKey.SECURITY_LOGIN_USERNAME, "test").setProperty(PropertyKey.MASTER_FILE_SYSTEM_OPERATION_RETRY_CACHE_ENABLED, false).build();
    @Rule
    public TestRule mResetRule = sLocalAlluxioClusterResource.getResetResource();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    private FileSystemMaster mFsMaster;

    @Before
    public final void before() throws Exception {
        this.mFsMaster = (FileSystemMaster)sLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class);
    }

    @Deprecated
    public void clientFileInfoDirectory() throws Exception {
        AlluxioURI path = new AlluxioURI("/testFolder");
        this.mFsMaster.createDirectory(path, CreateDirectoryContext.defaults());
        long fileId = this.mFsMaster.getFileId(path);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((Object)"testFolder", (Object)fileInfo.getName());
        Assert.assertEquals((long)0L, (long)fileInfo.getLength());
        Assert.assertFalse((boolean)fileInfo.isCacheable());
        Assert.assertTrue((boolean)fileInfo.isCompleted());
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertFalse((boolean)fileInfo.isPersisted());
        Assert.assertFalse((boolean)fileInfo.isPinned());
        Assert.assertEquals((Object)TEST_USER, (Object)fileInfo.getOwner());
        Assert.assertEquals((long)493L, (long)((short)fileInfo.getMode()));
    }

    @Deprecated
    public void clientFileInfoEmptyFile() throws Exception {
        FileInfo fileInfo = this.mFsMaster.createFile(new AlluxioURI("/testFile"), CreateFileContext.defaults());
        Assert.assertEquals((Object)"testFile", (Object)fileInfo.getName());
        Assert.assertEquals((long)0L, (long)fileInfo.getLength());
        Assert.assertTrue((boolean)fileInfo.isCacheable());
        Assert.assertFalse((boolean)fileInfo.isCompleted());
        Assert.assertFalse((boolean)fileInfo.isFolder());
        Assert.assertFalse((boolean)fileInfo.isPersisted());
        Assert.assertFalse((boolean)fileInfo.isPinned());
        Assert.assertEquals((long)-1L, (long)fileInfo.getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)fileInfo.getTtlAction());
        Assert.assertEquals((Object)TEST_USER, (Object)fileInfo.getOwner());
        Assert.assertEquals((long)420L, (long)((short)fileInfo.getMode()));
    }

    private FsMasterResource createFileSystemMasterFromJournal() throws Exception {
        return MasterTestUtils.createLeaderFileSystemMasterFromJournalCopy();
    }

    @Test
    public void concurrentCreate() throws Exception {
        ConcurrentCreator concurrentCreator = new ConcurrentCreator(6, 3, ROOT_PATH);
        concurrentCreator.call();
    }

    @Test
    public void concurrentDelete() throws Exception {
        ConcurrentCreator concurrentCreator = new ConcurrentCreator(6, 3, ROOT_PATH);
        concurrentCreator.call();
        ConcurrentDeleter concurrentDeleter = new ConcurrentDeleter(6, 3, ROOT_PATH);
        concurrentDeleter.call();
        Assert.assertEquals((long)0L, (long)this.mFsMaster.listStatus(new AlluxioURI("/"), ListStatusContext.defaults()).size());
    }

    @Test
    public void concurrentFree() throws Exception {
        ConcurrentCreator concurrentCreator = new ConcurrentCreator(6, 3, ROOT_PATH, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        concurrentCreator.call();
        ConcurrentFreer concurrentFreer = new ConcurrentFreer(6, 3, ROOT_PATH);
        concurrentFreer.call();
    }

    @Deprecated
    public void concurrentRename() throws Exception {
        ConcurrentCreator concurrentCreator = new ConcurrentCreator(6, 3, ROOT_PATH);
        concurrentCreator.call();
        int numFiles = this.mFsMaster.listStatus(ROOT_PATH, ListStatusContext.defaults()).size();
        ConcurrentRenamer concurrentRenamer = new ConcurrentRenamer(6, 3, ROOT_PATH, ROOT_PATH2, AlluxioURI.EMPTY_URI);
        concurrentRenamer.call();
        Assert.assertEquals((long)numFiles, (long)this.mFsMaster.listStatus(ROOT_PATH2, ListStatusContext.defaults()).size());
    }

    @Test
    public void createAlreadyExistFile() throws Exception {
        this.mThrown.expect(FileAlreadyExistsException.class);
        this.mFsMaster.createFile(new AlluxioURI("/testFile"), CreateFileContext.defaults());
        this.mFsMaster.createDirectory(new AlluxioURI("/testFile"), CreateDirectoryContext.defaults());
    }

    @Test
    public void createDirectory() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        FileInfo fileInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertEquals((Object)TEST_USER, (Object)fileInfo.getOwner());
        Assert.assertEquals((long)493L, (long)((short)fileInfo.getMode()));
    }

    @Test
    public void createFileInvalidPath() throws Exception {
        this.mThrown.expect(InvalidPathException.class);
        this.mFsMaster.createFile(new AlluxioURI("testFile"), CreateFileContext.defaults());
    }

    @Test
    public void createFileInvalidPathTest2() throws Exception {
        this.mThrown.expect(FileAlreadyExistsException.class);
        this.mFsMaster.createFile(new AlluxioURI("/"), CreateFileContext.defaults());
    }

    @Test
    public void createFileInvalidPathTest3() throws Exception {
        this.mThrown.expect(InvalidPathException.class);
        this.mFsMaster.createFile(new AlluxioURI("/testFile1"), CreateFileContext.defaults());
        this.mFsMaster.createFile(new AlluxioURI("/testFile1/testFile2"), CreateFileContext.defaults());
    }

    @Test
    public void createFilePerf() throws Exception {
        int k;
        for (k = 0; k < 200; ++k) {
            CreateDirectoryContext context = CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true));
            this.mFsMaster.createDirectory(new AlluxioURI("/testFile").join("COL_" + k).join("0"), context);
        }
        for (k = 0; k < 200; ++k) {
            this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFile").join("COL_" + k).join("0")));
        }
    }

    @Test
    public void createFile() throws Exception {
        this.mFsMaster.createFile(new AlluxioURI("/testFile"), CreateFileContext.defaults());
        FileInfo fileInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFile")));
        Assert.assertFalse((boolean)fileInfo.isFolder());
        Assert.assertEquals((Object)TEST_USER, (Object)fileInfo.getOwner());
        Assert.assertEquals((long)420L, (long)((short)fileInfo.getMode()));
    }

    @Test
    public void deleteUnsyncedDirectory() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/child"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        Files.createDirectory(Paths.get(ufs, "testFolder", "ufsOnlyDir"), new FileAttribute[0]);
        try {
            this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setUnchecked(false).setRecursive(true)));
            Assert.fail((String)"Expected deleting an out of sync directory to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mFsMaster.listStatus(new AlluxioURI("/testFolder"), ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.NEVER)));
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFsMaster.listStatus(new AlluxioURI("/testFolder/child"), ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS)));
    }

    @Test
    public void deleteDirectoryWithDirectories() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/testFolder2"), CreateDirectoryContext.defaults());
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), CreateFileContext.defaults()).getFileId();
        long fileId2 = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFolder2/testFile2"), CreateFileContext.defaults()).getFileId();
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        Assert.assertEquals((long)fileId2, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFolder2/testFile2")));
        this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFolder2/testFile2")));
    }

    @Test
    public void deleteDirectoryWithDirectoriesTest2() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/testFolder2"), CreateDirectoryContext.defaults());
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), CreateFileContext.defaults()).getFileId();
        long fileId2 = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFolder2/testFile2"), CreateFileContext.defaults()).getFileId();
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        Assert.assertEquals((long)fileId2, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFolder2/testFile2")));
        try {
            this.mFsMaster.delete(new AlluxioURI("/testFolder/testFolder2"), DeleteContext.defaults());
            Assert.fail((String)"Deleting a nonempty directory nonrecursively should fail");
        }
        catch (DirectoryNotEmptyException e) {
            Assert.assertEquals((Object)ExceptionMessage.DELETE_NONEMPTY_DIRECTORY_NONRECURSIVE.getMessage(new Object[]{"testFolder2"}), (Object)e.getMessage());
        }
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        Assert.assertEquals((long)fileId2, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFolder2/testFile2")));
    }

    @Test
    public void deleteDirectoryWithFiles() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), CreateFileContext.defaults()).getFileId();
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
    }

    @Test
    public void deleteDirectoryWithFilesTest2() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), CreateFileContext.defaults()).getFileId();
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        try {
            this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.defaults());
            Assert.fail((String)"Deleting a nonempty directory nonrecursively should fail");
        }
        catch (DirectoryNotEmptyException e) {
            Assert.assertEquals((Object)ExceptionMessage.DELETE_NONEMPTY_DIRECTORY_NONRECURSIVE.getMessage(new Object[]{"testFolder"}), (Object)e.getMessage());
        }
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
    }

    @Test
    public void deleteEmptyDirectory() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
    }

    @Test
    public void deleteDirectoryWithPersistedAndNotPersistedSubfolders() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/persisted"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/inAlluxio1"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder/inAlluxio1/inAlluxio2"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.delete(new AlluxioURI("/testFolder"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
    }

    @Test
    public void deleteDirectoryRecursive() throws Exception {
        AlluxioURI dir = new AlluxioURI("/testFolder");
        this.mFsMaster.createDirectory(dir, CreateDirectoryContext.defaults());
        FileSystem fs = sLocalAlluxioClusterResource.get().getClient();
        for (int i = 0; i < 3; ++i) {
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)PathUtils.concatPath((Object)dir, (Object)("file" + i)), (int)100, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        }
        fs.delete(dir, DeletePOptions.newBuilder().setRecursive(true).build());
        Assert.assertFalse((boolean)fs.exists(dir));
        BlockMasterClient blockClient = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        CommonUtils.waitFor((String)"data to be deleted", () -> {
            try {
                return blockClient.getUsedBytes() == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
    }

    @Test
    public void deleteFile() throws Exception {
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFile"), CreateFileContext.defaults()).getFileId();
        Assert.assertEquals((long)fileId, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFile")));
        this.mFsMaster.delete(new AlluxioURI("/testFile"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFile")));
    }

    @Test
    public void deleteRoot() throws Exception {
        this.mThrown.expect(InvalidPathException.class);
        this.mThrown.expectMessage(ExceptionMessage.DELETE_ROOT_DIRECTORY.getMessage(new Object[0]));
        this.mFsMaster.delete(new AlluxioURI("/"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true).setDeleteMountPoint(true)));
    }

    @Test
    public void getCapacityBytes() {
        BlockMaster blockMaster = (BlockMaster)sLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class);
        Assert.assertEquals((long)0xA00000L, (long)blockMaster.getCapacityBytes());
    }

    @Test
    public void lastModificationTimeCompleteFile() throws Exception {
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFile"), CreateFileContext.defaults()).getFileId();
        long opTimeMs = Long.MAX_VALUE;
        this.mFsMaster.completeFile(new AlluxioURI("/testFile"), CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setUfsLength(0L)).setOperationTimeMs(opTimeMs));
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((long)opTimeMs, (long)fileInfo.getLastModificationTimeMs());
        Assert.assertEquals((long)opTimeMs, (long)fileInfo.getLastAccessTimeMs());
    }

    @Test
    public void lastModificationTimeCreateFile() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long opTimeMs = Long.MAX_VALUE;
        CreateFileContext context = (CreateFileContext)CreateFileContext.defaults().setOperationTimeMs(opTimeMs);
        this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), context);
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
        Assert.assertEquals((long)opTimeMs, (long)folderInfo.getLastModificationTimeMs());
        Assert.assertEquals((long)opTimeMs, (long)folderInfo.getLastAccessTimeMs());
    }

    @Test
    public void lastModificationTimeDelete() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), CreateFileContext.defaults());
        long folderId = this.mFsMaster.getFileId(new AlluxioURI("/testFolder"));
        long modificationTimeBeforeDelete = this.mFsMaster.getFileInfo(folderId).getLastModificationTimeMs();
        long accessTimeBeforeDelete = this.mFsMaster.getFileInfo(folderId).getLastAccessTimeMs();
        CommonUtils.sleepMs((long)2L);
        this.mFsMaster.delete(new AlluxioURI("/testFolder/testFile"), DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        long modificationTimeAfterDelete = this.mFsMaster.getFileInfo(folderId).getLastModificationTimeMs();
        long accessTimeAfterDelete = this.mFsMaster.getFileInfo(folderId).getLastAccessTimeMs();
        Assert.assertTrue((modificationTimeBeforeDelete < modificationTimeAfterDelete ? 1 : 0) != 0);
        Assert.assertTrue((accessTimeBeforeDelete < accessTimeAfterDelete ? 1 : 0) != 0);
    }

    @Deprecated
    public void lastModificationTimeRename() throws Exception {
        AlluxioURI srcPath = new AlluxioURI("/testFolder/testFile1");
        AlluxioURI dstPath = new AlluxioURI("/testFolder/testFile2");
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        this.mFsMaster.createFile(srcPath, CreateFileContext.defaults());
        this.mFsMaster.rename(srcPath, dstPath, RenameContext.defaults().setOperationTimeMs(Long.MAX_VALUE));
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder")));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)folderInfo.getLastModificationTimeMs());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)folderInfo.getLastAccessTimeMs());
    }

    @Test
    public void listFiles() throws Exception {
        CreateFileContext options = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setBlockSizeBytes(64L));
        HashSet<Long> ids = new HashSet<Long>();
        HashSet<Long> dirIds = new HashSet<Long>();
        for (int i = 0; i < 10; ++i) {
            AlluxioURI dir = new AlluxioURI("/i" + i);
            this.mFsMaster.createDirectory(dir, CreateDirectoryContext.defaults());
            dirIds.add(this.mFsMaster.getFileId(dir));
            for (int j = 0; j < 10; ++j) {
                ids.add(this.mFsMaster.createFile(dir.join("j" + j), options).getFileId());
            }
        }
        HashSet<Long> listedIds = new HashSet<Long>();
        HashSet<Long> listedDirIds = new HashSet<Long>();
        List infoList = this.mFsMaster.listStatus(new AlluxioURI("/"), ListStatusContext.defaults());
        for (FileInfo info : infoList) {
            long id = info.getFileId();
            listedDirIds.add(id);
            for (FileInfo fileInfo : this.mFsMaster.listStatus(new AlluxioURI(info.getPath()), ListStatusContext.defaults())) {
                listedIds.add(fileInfo.getFileId());
            }
        }
        Assert.assertEquals(ids, listedIds);
        Assert.assertEquals(dirIds, listedDirIds);
    }

    @Test
    public void listStatus() throws Exception {
        int i;
        CreateFileContext options = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setBlockSizeBytes(64L));
        for (i = 0; i < 10; ++i) {
            this.mFsMaster.createDirectory(new AlluxioURI("/i" + i), CreateDirectoryContext.defaults());
            for (int j = 0; j < 10; ++j) {
                this.mFsMaster.createFile(new AlluxioURI("/i" + i + "/j" + j), options);
            }
        }
        Assert.assertEquals((long)1L, (long)this.mFsMaster.listStatus(new AlluxioURI("/i0/j0"), ListStatusContext.defaults()).size());
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)10L, (long)this.mFsMaster.listStatus(new AlluxioURI("/i" + i), ListStatusContext.defaults()).size());
        }
        Assert.assertEquals((long)10L, (long)this.mFsMaster.listStatus(new AlluxioURI("/"), ListStatusContext.defaults()).size());
    }

    @Test
    public void notFileCompletion() throws Exception {
        this.mThrown.expect(FileDoesNotExistException.class);
        this.mFsMaster.createDirectory(new AlluxioURI("/testFile"), CreateDirectoryContext.defaults());
        this.mFsMaster.completeFile(new AlluxioURI("/testFile"), CompleteFileContext.defaults());
    }

    @Test
    public void renameExistingDst() throws Exception {
        this.mFsMaster.createFile(new AlluxioURI("/testFile1"), CreateFileContext.defaults());
        this.mFsMaster.createFile(new AlluxioURI("/testFile2"), CreateFileContext.defaults());
        try {
            this.mFsMaster.rename(new AlluxioURI("/testFile1"), new AlluxioURI("/testFile2"), RenameContext.defaults());
            Assert.fail((String)"Should not be able to rename to an existing file");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void renameNonexistent() throws Exception {
        this.mFsMaster.createFile(new AlluxioURI("/testFile1"), CreateFileContext.defaults());
        Assert.assertEquals((long)-1L, (long)this.mFsMaster.getFileId(new AlluxioURI("/testFile2")));
    }

    @Test
    public void renameToDeeper() throws Exception {
        CreateFileContext createFileOptions = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setRecursive(true));
        CreateDirectoryContext createDirectoryContext = CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true));
        this.mThrown.expect(InvalidPathException.class);
        this.mFsMaster.createDirectory(new AlluxioURI("/testDir1/testDir2"), createDirectoryContext);
        this.mFsMaster.createFile(new AlluxioURI("/testDir1/testDir2/testDir3/testFile3"), createFileOptions);
        this.mFsMaster.rename(new AlluxioURI("/testDir1/testDir2"), new AlluxioURI("/testDir1/testDir2/testDir3/testDir4"), RenameContext.defaults());
    }

    @Test
    public void ttlCreateFile() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long ttl = 100L;
        CreateFileContext context = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl).setTtlAction(TtlAction.FREE)));
        this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile"), context);
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile")));
        Assert.assertEquals((long)ttl, (long)folderInfo.getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)folderInfo.getTtlAction());
    }

    @Test
    public void ttlExpiredCreateFile() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long ttl = 1L;
        CreateFileContext context = (CreateFileContext)CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl))).setWriteType(WriteType.CACHE_THROUGH);
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile1"), context).getFileId();
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile1")));
        Assert.assertEquals((long)fileId, (long)folderInfo.getFileId());
        Assert.assertEquals((long)ttl, (long)folderInfo.getTtl());
        CommonUtils.sleepMs((long)200L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        HeartbeatScheduler.await((String)"Master TTL Check", (long)10L, (TimeUnit)TimeUnit.SECONDS);
        HeartbeatScheduler.schedule((String)"Master TTL Check");
        HeartbeatScheduler.await((String)"Master TTL Check", (long)10L, (TimeUnit)TimeUnit.SECONDS);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((long)-1L, (long)fileInfo.getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)fileInfo.getTtlAction());
    }

    @Test
    public void ttlExpiredCreateFileWithFreeAction() throws Exception {
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long ttl = 1L;
        CreateFileContext context = (CreateFileContext)CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl).setTtlAction(TtlAction.FREE))).setWriteType(WriteType.CACHE_THROUGH);
        long fileId = this.mFsMaster.createFile(new AlluxioURI("/testFolder/testFile1"), context).getFileId();
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile1")));
        Assert.assertEquals((long)fileId, (long)folderInfo.getFileId());
        Assert.assertEquals((long)ttl, (long)folderInfo.getTtl());
        Assert.assertEquals((Object)TtlAction.FREE, (Object)folderInfo.getTtlAction());
        CommonUtils.sleepMs((long)200L);
        HeartbeatScheduler.await((String)"Master TTL Check", (long)10L, (TimeUnit)TimeUnit.SECONDS);
        HeartbeatScheduler.schedule((String)"Master TTL Check");
        HeartbeatScheduler.await((String)"Master TTL Check", (long)10L, (TimeUnit)TimeUnit.SECONDS);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((long)-1L, (long)fileInfo.getTtl());
        Assert.assertEquals((Object)TtlAction.DELETE, (Object)fileInfo.getTtlAction());
    }

    @Deprecated
    public void ttlRename() throws Exception {
        AlluxioURI srcPath = new AlluxioURI("/testFolder/testFile1");
        AlluxioURI dstPath = new AlluxioURI("/testFolder/testFile2");
        this.mFsMaster.createDirectory(new AlluxioURI("/testFolder"), CreateDirectoryContext.defaults());
        long ttl = 1L;
        CreateFileContext context = CreateFileContext.mergeFrom((CreateFilePOptions.Builder)CreateFilePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttl)));
        this.mFsMaster.createFile(srcPath, context);
        this.mFsMaster.rename(srcPath, dstPath, RenameContext.defaults().setOperationTimeMs(Long.MAX_VALUE));
        FileInfo folderInfo = this.mFsMaster.getFileInfo(this.mFsMaster.getFileId(new AlluxioURI("/testFolder/testFile2")));
        Assert.assertEquals((long)ttl, (long)folderInfo.getTtl());
    }

    @Test
    public void ufsModeCreateFile() throws Exception {
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mFsMaster.createFile(new AlluxioURI("/in_alluxio"), (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.MUST_CACHE));
        this.mThrown.expect(AccessControlException.class);
        this.mFsMaster.createFile(new AlluxioURI("/in_ufs"), (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
    }

    @Test
    public void ufsModeCreateDirectory() throws Exception {
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mFsMaster.createDirectory(new AlluxioURI("/in_alluxio"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.MUST_CACHE));
        this.mThrown.expect(AccessControlException.class);
        this.mFsMaster.createDirectory(new AlluxioURI("/in_ufs"), (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
    }

    @Test
    public void ufsModeDeleteFile() throws Exception {
        AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
        this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mThrown.expect(FailedPreconditionException.class);
        this.mFsMaster.delete(alluxioFile, DeleteContext.defaults());
    }

    @Test
    public void ufsModeDeleteDirectory() throws Exception {
        AlluxioURI alluxioDirectory = new AlluxioURI("/in_ufs_dir");
        this.mFsMaster.createDirectory(alluxioDirectory, (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        AlluxioURI alluxioFile = new AlluxioURI("/in_ufs_dir/in_ufs_file");
        this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mThrown.expect(FailedPreconditionException.class);
        this.mFsMaster.delete(alluxioDirectory, DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
        long dirId = this.mFsMaster.getFileId(alluxioDirectory);
        Assert.assertNotEquals((long)-1L, (long)dirId);
        long fileId = this.mFsMaster.getFileId(alluxioFile);
        Assert.assertNotEquals((long)-1L, (long)fileId);
    }

    @Test
    public void ufsModeRenameFile() throws Exception {
        this.mFsMaster.createFile(new AlluxioURI("/in_ufs_src"), (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mThrown.expect(AccessControlException.class);
        this.mFsMaster.rename(new AlluxioURI("/in_ufs_src"), new AlluxioURI("/in_ufs_dst"), RenameContext.defaults());
    }

    @Test
    public void ufsModeRenameDirectory() throws Exception {
        AlluxioURI alluxioDirectory = new AlluxioURI("/in_ufs_dir");
        this.mFsMaster.createDirectory(alluxioDirectory, (CreateDirectoryContext)CreateDirectoryContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        AlluxioURI alluxioFile = new AlluxioURI("/in_ufs_dir/in_ufs_file");
        this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        this.mThrown.expect(AccessControlException.class);
        this.mFsMaster.rename(alluxioDirectory, new AlluxioURI("/in_ufs_dst"), RenameContext.defaults());
        long dirId = this.mFsMaster.getFileId(alluxioDirectory);
        Assert.assertNotEquals((long)-1L, (long)dirId);
        long fileId = this.mFsMaster.getFileId(alluxioFile);
        Assert.assertNotEquals((long)-1L, (long)fileId);
    }

    @Test
    public void ufsModeSetAttribute() throws Exception {
        AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
        this.mFsMaster.createFile(alluxioFile, (CreateFileContext)CreateFileContext.defaults().setWriteType(WriteType.CACHE_THROUGH));
        this.mFsMaster.updateUfsMode(new AlluxioURI(this.mFsMaster.getUfsAddress()), UfsMode.READ_ONLY);
        long opTimeMs = Long.MAX_VALUE;
        this.mFsMaster.completeFile(alluxioFile, CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setUfsLength(0L)).setOperationTimeMs(opTimeMs));
        this.mThrown.expect(AccessControlException.class);
        this.mFsMaster.setAttribute(alluxioFile, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto())));
    }

    @Deprecated
    public void setModeOwnerNoWritePermission() throws Exception {
        AlluxioURI root = new AlluxioURI("/");
        this.mFsMaster.setAttribute(root, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto())));
        try (Closeable closeable = new AuthenticatedUserRule("foo", Configuration.global()).toResource();){
            AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
            FileInfo file = this.mFsMaster.createFile(alluxioFile, CreateFileContext.defaults());
            long opTimeMs = Long.MAX_VALUE;
            this.mFsMaster.completeFile(alluxioFile, CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setUfsLength(0L)).setOperationTimeMs(opTimeMs));
            this.mFsMaster.setAttribute(alluxioFile, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(263).toProto())));
            Assert.assertEquals((long)263L, (long)this.mFsMaster.getFileInfo(file.getFileId()).getMode());
            this.mFsMaster.setAttribute(alluxioFile, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto())));
            Assert.assertEquals((long)511L, (long)this.mFsMaster.getFileInfo(file.getFileId()).getMode());
        }
    }

    @Deprecated
    public void setModeNoOwner() throws Exception {
        AlluxioURI root = new AlluxioURI("/");
        this.mFsMaster.setAttribute(root, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto())));
        AlluxioURI alluxioFile = new AlluxioURI("/in_alluxio");
        try (Closeable closeable = new AuthenticatedUserRule("foo", Configuration.global()).toResource();){
            FileInfo file = this.mFsMaster.createFile(alluxioFile, CreateFileContext.defaults());
            long opTimeMs = Long.MAX_VALUE;
            this.mFsMaster.completeFile(alluxioFile, CompleteFileContext.mergeFrom((CompleteFilePOptions.Builder)CompleteFilePOptions.newBuilder().setUfsLength(0L)).setOperationTimeMs(opTimeMs));
            this.mFsMaster.setAttribute(alluxioFile, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(511).toProto())));
            Assert.assertEquals((long)511L, (long)this.mFsMaster.getFileInfo(file.getFileId()).getMode());
        }
        this.mThrown.expect(AccessControlException.class);
        closeable = new AuthenticatedUserRule("bar", Configuration.global()).toResource();
        var4_4 = null;
        try {
            this.mFsMaster.setAttribute(alluxioFile, SetAttributeContext.mergeFrom((SetAttributePOptions.Builder)SetAttributePOptions.newBuilder().setMode(new Mode(447).toProto())));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (var4_4 != null) {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    closeable.close();
                }
            }
        }
    }

    @Test
    public void createDirectoryInNestedDirectories() throws Exception {
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String targetPath = Paths.get(ufs, "d1", "d2", "d3").toString();
        FileUtils.createDir((String)targetPath);
        FileUtils.changeLocalFilePermission((String)targetPath, (String)new Mode(493).toString());
        String parentPath = Paths.get(ufs, "d1").toString();
        FileUtils.changeLocalFilePermission((String)parentPath, (String)new Mode(448).toString());
        AlluxioURI path = new AlluxioURI(Paths.get("/d1", "d2", "d3", "d4").toString());
        this.mFsMaster.createDirectory(path, (CreateDirectoryContext)CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(493).toProto())).setWriteType(WriteType.CACHE_THROUGH));
        long fileId = this.mFsMaster.getFileId(new AlluxioURI("/d1"));
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((Object)"d1", (Object)fileInfo.getName());
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertTrue((boolean)fileInfo.isPersisted());
        Assert.assertEquals((long)448L, (long)((short)fileInfo.getMode()));
    }

    @Test
    public void loadMetadataInNestedDirectories() throws Exception {
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String targetPath = Paths.get(ufs, "d1", "d2", "d3").toString();
        FileUtils.createDir((String)targetPath);
        FileUtils.changeLocalFilePermission((String)targetPath, (String)new Mode(493).toString());
        String parentPath = Paths.get(ufs, "d1").toString();
        FileUtils.changeLocalFilePermission((String)parentPath, (String)new Mode(448).toString());
        AlluxioURI path = new AlluxioURI(Paths.get("/d1", "d2", "d3").toString());
        this.mFsMaster.listStatus(path, ListStatusContext.mergeFrom((ListStatusPOptions.Builder)ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ONCE)));
        long fileId = this.mFsMaster.getFileId(new AlluxioURI("/d1"));
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((Object)"d1", (Object)fileInfo.getName());
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertTrue((boolean)fileInfo.isPersisted());
        Assert.assertEquals((long)448L, (long)((short)fileInfo.getMode()));
    }

    @Test
    public void createNestedDirectories() throws Exception {
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String parentPath = Paths.get(ufs, "d1").toString();
        FileUtils.createDir((String)parentPath);
        FileUtils.changeLocalFilePermission((String)parentPath, (String)new Mode(493).toString());
        AlluxioURI path = new AlluxioURI(Paths.get("/d1", "d2", "d3", "d4").toString());
        String ufsPath = Paths.get(ufs, "d1", "d2", "d3", "d4").toString();
        this.mFsMaster.createDirectory(path, (CreateDirectoryContext)CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(448).toProto())).setWriteType(WriteType.CACHE_THROUGH));
        long fileId = this.mFsMaster.getFileId(path);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        Assert.assertEquals((Object)"d4", (Object)fileInfo.getName());
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertTrue((boolean)fileInfo.isPersisted());
        Assert.assertEquals((long)448L, (long)((short)fileInfo.getMode()));
        Assert.assertTrue((boolean)FileUtils.exists((String)ufsPath));
        Assert.assertEquals((long)448L, (long)FileUtils.getLocalFileMode((String)ufsPath));
    }

    @Test(expected=IOException.class)
    public void createDirectoryInNestedDirectoriesWithoutExecutePermission() throws Exception {
        Assume.assumeFalse((boolean)ShellUtils.execCommand((String[])new String[]{"id", "-u"}).trim().equals("0"));
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String parentPath = Paths.get(ufs, "d1").toString();
        FileUtils.createDir((String)parentPath);
        FileUtils.changeLocalFilePermission((String)parentPath, (String)new Mode(384).toString());
        AlluxioURI path = new AlluxioURI(Paths.get("/d1", "d2", "d3", "d4").toString());
        this.mFsMaster.createDirectory(path, (CreateDirectoryContext)CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(493).toProto())).setWriteType(WriteType.CACHE_THROUGH));
    }

    @Test
    public void loadDirectoryTimestamps() throws Exception {
        String name = "d1";
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String ufsPath = Paths.get(ufs, name).toString();
        FileUtils.createDir((String)ufsPath);
        File file = new File(ufsPath);
        long ufsTime = file.lastModified();
        Thread.sleep(100L);
        AlluxioURI path = new AlluxioURI("/" + name);
        long fileId = this.mFsMaster.getFileId(path);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        long alluxioTime = fileInfo.getLastModificationTimeMs();
        Assert.assertEquals((Object)name, (Object)fileInfo.getName());
        Assert.assertTrue((boolean)fileInfo.isFolder());
        Assert.assertTrue((boolean)fileInfo.isPersisted());
        Assert.assertEquals((long)ufsTime, (long)alluxioTime);
    }

    @Test
    public void loadFileTimestamps() throws Exception {
        String name = "f1";
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String ufsPath = Paths.get(ufs, name).toString();
        FileUtils.createFile((String)ufsPath);
        File file = new File(ufsPath);
        long actualTime = file.lastModified();
        Thread.sleep(100L);
        AlluxioURI path = new AlluxioURI("/" + name);
        long fileId = this.mFsMaster.getFileId(path);
        FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
        long alluxioTime = fileInfo.getLastModificationTimeMs();
        Assert.assertEquals((Object)name, (Object)fileInfo.getName());
        Assert.assertFalse((boolean)fileInfo.isFolder());
        Assert.assertTrue((boolean)fileInfo.isPersisted());
        Assert.assertEquals((long)actualTime, (long)alluxioTime);
    }

    @Test
    public void loadParentDirectoryTimestamps() throws Exception {
        String parentName = "d1";
        String childName = "d2";
        String ufs = Configuration.getString((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
        String parentUfsPath = Paths.get(ufs, parentName).toString();
        FileUtils.createDir((String)parentUfsPath);
        File file = new File(parentUfsPath);
        long actualTime = file.lastModified();
        Thread.sleep(100L);
        AlluxioURI parentPath = new AlluxioURI("/" + parentName);
        AlluxioURI path = new AlluxioURI("/" + Paths.get(parentName, childName));
        this.mFsMaster.createDirectory(path, (CreateDirectoryContext)CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true).setMode(new Mode(448).toProto())).setWriteType(WriteType.CACHE_THROUGH));
        long fileId = this.mFsMaster.getFileId(path);
        this.mFsMaster.getFileInfo(fileId);
        long parentId = this.mFsMaster.getFileId(parentPath);
        FileInfo parentInfo = this.mFsMaster.getFileInfo(parentId);
        long alluxioTime = parentInfo.getLastModificationTimeMs();
        Assert.assertEquals((Object)parentName, (Object)parentInfo.getName());
        Assert.assertTrue((boolean)parentInfo.isFolder());
        Assert.assertTrue((boolean)parentInfo.isPersisted());
        Assert.assertEquals((long)actualTime, (long)alluxioTime);
        Assert.assertTrue((boolean)FileUtils.exists((String)parentUfsPath));
    }

    class ConcurrentRenamer
    implements Callable<Void> {
        private int mDepth;
        private int mConcurrencyDepth;
        private AlluxioURI mRootPath;
        private AlluxioURI mRootPath2;
        private AlluxioURI mInitPath;

        ConcurrentRenamer(int depth, int concurrencyDepth, AlluxioURI rootPath, AlluxioURI rootPath2, AlluxioURI initPath) {
            this.mDepth = depth;
            this.mConcurrencyDepth = concurrencyDepth;
            this.mRootPath = rootPath;
            this.mRootPath2 = rootPath2;
            this.mInitPath = initPath;
        }

        @Override
        @Nullable
        public Void call() throws Exception {
            AuthenticatedClientUser.set((String)FileSystemMasterIntegrationTest.TEST_USER);
            this.exec(this.mDepth, this.mConcurrencyDepth, this.mInitPath);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exec(int depth, int concurrencyDepth, AlluxioURI path) throws Exception {
            if (depth < 1) {
                return;
            }
            if (depth == 1 || depth < this.mDepth && path.hashCode() % 10 < 3) {
                AlluxioURI srcPath = this.mRootPath.join(path);
                AlluxioURI dstPath = this.mRootPath2.join(path);
                long fileId = FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(srcPath);
                try {
                    CreateDirectoryContext context = CreateDirectoryContext.mergeFrom((CreateDirectoryPOptions.Builder)CreateDirectoryPOptions.newBuilder().setRecursive(true));
                    FileSystemMasterIntegrationTest.this.mFsMaster.createDirectory(dstPath.getParent(), context);
                }
                catch (FileAlreadyExistsException | InvalidPathException throwable) {
                    // empty catch block
                }
                FileSystemMasterIntegrationTest.this.mFsMaster.rename(srcPath, dstPath, RenameContext.defaults());
                Assert.assertEquals((long)fileId, (long)FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(dstPath));
            } else if (concurrencyDepth > 0) {
                ExecutorService executor = Executors.newCachedThreadPool();
                try {
                    ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(4);
                    for (int i = 0; i < 4; ++i) {
                        ConcurrentRenamer concurrentRenamer = new ConcurrentRenamer(depth - 1, concurrencyDepth - 1, this.mRootPath, this.mRootPath2, path.join(Integer.toString(i)));
                        futures.add(executor.submit(concurrentRenamer));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                }
                finally {
                    executor.shutdown();
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.exec(depth - 1, concurrencyDepth, path.join(Integer.toString(i)));
                }
            }
        }
    }

    class ConcurrentDeleter
    implements Callable<Void> {
        private int mDepth;
        private int mConcurrencyDepth;
        private AlluxioURI mInitPath;

        ConcurrentDeleter(int depth, int concurrencyDepth, AlluxioURI initPath) {
            this.mDepth = depth;
            this.mConcurrencyDepth = concurrencyDepth;
            this.mInitPath = initPath;
        }

        @Override
        @Nullable
        public Void call() throws Exception {
            AuthenticatedClientUser.set((String)FileSystemMasterIntegrationTest.TEST_USER);
            this.exec(this.mDepth, this.mConcurrencyDepth, this.mInitPath);
            return null;
        }

        private void doDelete(AlluxioURI path) throws Exception {
            FileSystemMasterIntegrationTest.this.mFsMaster.delete(path, DeleteContext.mergeFrom((DeletePOptions.Builder)DeletePOptions.newBuilder().setRecursive(true)));
            Assert.assertEquals((long)-1L, (long)FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exec(int depth, int concurrencyDepth, AlluxioURI path) throws Exception {
            if (depth < 1) {
                return;
            }
            if (depth == 1 || path.hashCode() % 10 == 0) {
                this.doDelete(path);
            } else {
                if (concurrencyDepth > 0) {
                    ExecutorService executor = Executors.newCachedThreadPool();
                    try {
                        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(4);
                        for (int i = 0; i < 4; ++i) {
                            ConcurrentDeleter concurrentDeleter = new ConcurrentDeleter(depth - 1, concurrencyDepth - 1, path.join(Integer.toString(i)));
                            futures.add(executor.submit(concurrentDeleter));
                        }
                        for (Future future : futures) {
                            future.get();
                        }
                    }
                    finally {
                        executor.shutdown();
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.exec(depth - 1, concurrencyDepth, path.join(Integer.toString(i)));
                    }
                }
                this.doDelete(path);
            }
        }
    }

    class ConcurrentFreer
    implements Callable<Void> {
        private int mDepth;
        private int mConcurrencyDepth;
        private AlluxioURI mInitPath;

        ConcurrentFreer(int depth, int concurrencyDepth, AlluxioURI initPath) {
            this.mDepth = depth;
            this.mConcurrencyDepth = concurrencyDepth;
            this.mInitPath = initPath;
        }

        @Override
        @Nullable
        public Void call() throws Exception {
            AuthenticatedClientUser.set((String)FileSystemMasterIntegrationTest.TEST_USER);
            this.exec(this.mDepth, this.mConcurrencyDepth, this.mInitPath);
            return null;
        }

        private void doFree(AlluxioURI path) throws Exception {
            FileSystemMasterIntegrationTest.this.mFsMaster.free(path, FreeContext.mergeFrom((FreePOptions.Builder)FreePOptions.newBuilder().setForced(true).setRecursive(true)));
            Assert.assertNotEquals((long)-1L, (long)FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exec(int depth, int concurrencyDepth, AlluxioURI path) throws Exception {
            if (depth < 1) {
                return;
            }
            if (depth == 1 || path.hashCode() % 10 == 0) {
                this.doFree(path);
            } else {
                if (concurrencyDepth > 0) {
                    ExecutorService executor = Executors.newCachedThreadPool();
                    try {
                        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(4);
                        for (int i = 0; i < 4; ++i) {
                            ConcurrentDeleter concurrentDeleter = new ConcurrentDeleter(depth - 1, concurrencyDepth - 1, path.join(Integer.toString(i)));
                            futures.add(executor.submit(concurrentDeleter));
                        }
                        for (Future future : futures) {
                            future.get();
                        }
                    }
                    finally {
                        executor.shutdown();
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.exec(depth - 1, concurrencyDepth, path.join(Integer.toString(i)));
                    }
                }
                this.doFree(path);
            }
        }
    }

    class ConcurrentCreator
    implements Callable<Void> {
        private int mDepth;
        private int mConcurrencyDepth;
        private AlluxioURI mInitPath;
        private CreateFileContext mCreateFileContext;

        ConcurrentCreator(int depth, int concurrencyDepth, AlluxioURI initPath) {
            this(depth, concurrencyDepth, initPath, CreateFileContext.defaults());
        }

        ConcurrentCreator(int depth, int concurrencyDepth, AlluxioURI initPath, CreateFileContext context) {
            this.mDepth = depth;
            this.mConcurrencyDepth = concurrencyDepth;
            this.mInitPath = initPath;
            this.mCreateFileContext = context;
        }

        @Override
        @Nullable
        public Void call() throws Exception {
            AuthenticatedClientUser.set((String)FileSystemMasterIntegrationTest.TEST_USER);
            this.exec(this.mDepth, this.mConcurrencyDepth, this.mInitPath);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exec(int depth, int concurrencyDepth, AlluxioURI path) throws Exception {
            CreateFileContext context = CreateFileContext.create((CreateFilePOptions.Builder)((CreateFilePOptions.Builder)this.mCreateFileContext.getOptions()));
            if (depth < 1) {
                return;
            }
            if (depth == 1) {
                long fileId = FileSystemMasterIntegrationTest.this.mFsMaster.createFile(path, context).getFileId();
                Assert.assertEquals((long)fileId, (long)FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(path));
                FileInfo fileInfo = FileSystemMasterIntegrationTest.this.mFsMaster.getFileInfo(fileId);
                Assert.assertEquals((Object)FileSystemMasterIntegrationTest.TEST_USER, (Object)fileInfo.getOwner());
                Assert.assertEquals((long)420L, (long)((short)fileInfo.getMode()));
            } else {
                FileSystemMasterIntegrationTest.this.mFsMaster.createDirectory(path, CreateDirectoryContext.defaults());
                Assert.assertNotNull((Object)FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(path));
                long dirId = FileSystemMasterIntegrationTest.this.mFsMaster.getFileId(path);
                Assert.assertNotEquals((long)-1L, (long)dirId);
                FileInfo dirInfo = FileSystemMasterIntegrationTest.this.mFsMaster.getFileInfo(dirId);
                Assert.assertEquals((Object)FileSystemMasterIntegrationTest.TEST_USER, (Object)dirInfo.getOwner());
                Assert.assertEquals((long)493L, (long)((short)dirInfo.getMode()));
            }
            if (concurrencyDepth > 0) {
                ExecutorService executor = Executors.newCachedThreadPool();
                try {
                    ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(4);
                    for (int i = 0; i < 4; ++i) {
                        ConcurrentCreator concurrentCreator = new ConcurrentCreator(depth - 1, concurrencyDepth - 1, path.join(Integer.toString(i)), this.mCreateFileContext);
                        futures.add(executor.submit(concurrentCreator));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                }
                finally {
                    executor.shutdown();
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.exec(depth - 1, concurrencyDepth, path.join(Integer.toString(i)));
                }
            }
        }
    }
}

