/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.PathUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="check the block locking tests")
public class IsolatedFileSystemIntegrationTest
extends BaseIntegrationTest {
    private static final int WORKER_CAPACITY_BYTES = 0xC800000;
    private static final int WORKER_UNRESERVED_BYTES = 0xB400000;
    private static final int USER_QUOTA_UNIT_BYTES = 1000;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.WORKER_RAMDISK_SIZE, 0xC800000).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x6400000).setProperty(PropertyKey.USER_FILE_RESERVED_BYTES, 1000).setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 1000).build();
    private FileSystem mFileSystem = null;
    private CreateFilePOptions mWriteBoth;

    @Before
    public final void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mWriteBoth = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
    }

    @Test
    public void lockBlockTest1() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(k)).getInAlluxioPercentage());
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    @Test
    public void lockBlockTest2() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            URIStatus info = this.mFileSystem.getStatus((AlluxioURI)files.get(k));
            Assert.assertTrue((info.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            FileInStream is = this.mFileSystem.openFile((AlluxioURI)files.get(k), FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)this.mWriteBoth));
            ByteBuffer buf = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            Assert.assertTrue((is.read(buf.array()) != -1 ? 1 : 0) != 0);
            is.close();
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    @Test
    public void lockBlockTest3() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            URIStatus info = this.mFileSystem.getStatus((AlluxioURI)files.get(k));
            Assert.assertTrue((info.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            FileInStream is = this.mFileSystem.openFile((AlluxioURI)files.get(k), FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)this.mWriteBoth));
            ByteBuffer buf = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            int r = is.read(buf.array());
            if (k < numOfFiles - 1) {
                Assert.assertTrue((r != -1 ? 1 : 0) != 0);
            }
            is.close();
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    @Test
    public void unlockBlockTest1() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            URIStatus info = this.mFileSystem.getStatus((AlluxioURI)files.get(k));
            FileInStream is = this.mFileSystem.openFile((AlluxioURI)files.get(k), FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)this.mWriteBoth));
            ByteBuffer buf = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            Assert.assertTrue((info.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            Assert.assertTrue((is.read(buf.array()) != -1 ? 1 : 0) != 0);
            is.close();
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    @Test
    public void unlockBlockTest2() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            URIStatus info = this.mFileSystem.getStatus((AlluxioURI)files.get(k));
            Assert.assertTrue((info.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            FileInStream is = this.mFileSystem.openFile((AlluxioURI)files.get(k), FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)this.mWriteBoth));
            ByteBuffer buf = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            Assert.assertTrue((is.read(buf.array()) != -1 ? 1 : 0) != 0);
            is.seek(0L);
            buf.clear();
            Assert.assertTrue((is.read(buf.array()) != -1 ? 1 : 0) != 0);
            is.close();
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    @Test
    public void unlockBlockTest3() throws Exception {
        int k;
        String uniqPath = PathUtils.uniqPath();
        int numOfFiles = 5;
        int fileSize = 0xB400000 / numOfFiles;
        ArrayList<AlluxioURI> files = new ArrayList<AlluxioURI>();
        for (k = 0; k < numOfFiles; ++k) {
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + k), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
            files.add(new AlluxioURI(uniqPath + k));
        }
        for (k = 0; k < numOfFiles; ++k) {
            URIStatus info = this.mFileSystem.getStatus((AlluxioURI)files.get(k));
            Assert.assertTrue((info.getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            FileInStream is = this.mFileSystem.openFile((AlluxioURI)files.get(k), FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)this.mWriteBoth));
            ByteBuffer buf1 = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            Assert.assertTrue((is.read(buf1.array()) != -1 ? 1 : 0) != 0);
            ByteBuffer buf2 = ByteBuffer.allocate((int)info.getBlockSizeBytes());
            is.seek(0L);
            Assert.assertTrue((is.read(buf2.array()) != -1 ? 1 : 0) != 0);
            is.close();
        }
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)(uniqPath + numOfFiles), (int)fileSize, (CreateFilePOptions)this.mWriteBoth);
        files.add(new AlluxioURI(uniqPath + numOfFiles));
        Assert.assertEquals((long)numOfFiles, (long)this.numCached(files));
        Assert.assertEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(numOfFiles)).getInAlluxioPercentage());
        Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus((AlluxioURI)files.get(0)).getInAlluxioPercentage());
    }

    private long numCached(List<AlluxioURI> fileUris) {
        return fileUris.stream().map(uri -> {
            try {
                return this.mFileSystem.getStatus(uri);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).filter(status -> status.getInAlluxioPercentage() == 100).count();
    }
}

