/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.CacheManagerOptions;
import alluxio.client.file.cache.LocalCacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.util.CommonUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.FileUtils;
import java.nio.file.Paths;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public final class LocalCacheManagerIntegrationTest
extends BaseIntegrationTest {
    private static final int PAGE_SIZE_BYTES = 1024;
    private static final int PAGE_COUNT = 32;
    private static final int CACHE_SIZE_BYTES = 32768;
    private static final PageId PAGE_ID = new PageId("0", 0L);
    private static final byte[] PAGE = BufferUtils.getIncreasingByteArray((int)1024);
    @Rule
    public TemporaryFolder mTemp = new TemporaryFolder();
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    private LocalCacheManager mCacheManager;
    private InstancedConfiguration mConf;
    private PageMetaStore mPageMetaStore;
    private List<PageStoreDir> mPageStoreDirs;
    private final byte[] mBuffer = new byte[1024];
    private CacheManagerOptions mCacheManagerOptions;

    @Before
    public void before() throws Exception {
        this.mConf = new InstancedConfiguration(new AlluxioProperties());
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE, (Object)1024);
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_SIZE, String.valueOf(32768));
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_ENABLED, (Object)true);
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_DIRS, this.mTemp.getRoot().getPath());
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED, (Object)false);
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED, (Object)false);
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD, (Object)0);
        this.mCacheManagerOptions = CacheManagerOptions.create((AlluxioConfiguration)this.mConf);
        this.mPageMetaStore = PageMetaStore.create((CacheManagerOptions)this.mCacheManagerOptions);
    }

    @After
    public void after() throws Exception {
        if (this.mCacheManager != null) {
            this.mCacheManager.close();
        }
    }

    @Test
    public void newCacheLocal() throws Exception {
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, (Object)PageStoreType.LOCAL);
        this.testNewCache();
    }

    private void testNewCache() throws Exception {
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        this.mCacheManager.put(PAGE_ID, PAGE);
        this.testPageCached();
    }

    private void testPageCached() {
        this.testPageCached(PAGE_ID);
    }

    private void testPageCached(PageId pageId) {
        Assert.assertEquals((long)1024L, (long)this.mCacheManager.get(pageId, 1024, this.mBuffer, 0));
        Assert.assertArrayEquals((byte[])PAGE, (byte[])this.mBuffer);
    }

    @Test
    public void loadCacheLocal() throws Exception {
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, (Object)PageStoreType.LOCAL);
        this.testLoadCache();
    }

    @Test
    public void loadCacheAndEvict() throws Exception {
        int i;
        this.loadFullCache();
        this.mCacheManager.close();
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        for (int i2 = 0; i2 < 16; ++i2) {
            this.mCacheManager.put(new PageId("1", (long)i2), PAGE);
        }
        int evicted = 0;
        for (i = 0; i < 32; ++i) {
            PageId pageId = new PageId("0", (long)i);
            int ret = this.mCacheManager.get(pageId, 1024, this.mBuffer, 0);
            Assert.assertArrayEquals((byte[])PAGE, (byte[])this.mBuffer);
            if (ret <= 0) {
                ++evicted;
                continue;
            }
            Assert.assertEquals((long)1024L, (long)this.mCacheManager.get(pageId, 1024, this.mBuffer, 0));
        }
        Assert.assertEquals((long)16L, (long)evicted);
        for (i = 0; i < 16; ++i) {
            this.testPageCached(new PageId("1", (long)i));
        }
    }

    private void testLoadCache() throws Exception {
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        this.mCacheManager.put(PAGE_ID, PAGE);
        this.testPageCached();
        this.mCacheManager.close();
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        this.testPageCached();
    }

    @Test
    public void loadCacheMismatchedPageSize() throws Exception {
        this.testLoadCacheConfMismatch(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE, 2048);
    }

    @Test
    public void loadCacheSmallerNewCacheSizeLocal() throws Exception {
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, (Object)PageStoreType.LOCAL);
        this.loadFullCache();
        this.mCacheManager.close();
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_SIZE, String.valueOf(16384));
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        CommonUtils.waitFor((String)"async restore completed", () -> this.mCacheManager.state() == CacheManager.State.READ_WRITE, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(10000L));
        int hits = 0;
        for (int i = 0; i < 32; ++i) {
            if (1024 != this.mCacheManager.get(new PageId("0", (long)i), 1024, this.mBuffer, 0)) continue;
            ++hits;
        }
        if (hits < 16) {
            Assert.fail((String)String.format("Expected at least %s hits but actually got %s hits", 16, hits));
        }
    }

    @Test
    public void loadCacheWithInvalidPageFile() throws Exception {
        this.mConf.set(PropertyKey.USER_CLIENT_CACHE_STORE_TYPE, (Object)PageStoreType.LOCAL);
        this.loadFullCache();
        this.mCacheManager.close();
        String rootDir = ((PageStoreDir)this.mPageMetaStore.getStoreDirs().get(0)).getRootPath().toString();
        String invalidPageFileName = Paths.get(rootDir, "invalidPageFile").toString();
        FileUtils.createFile((String)invalidPageFileName);
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        Assert.assertEquals((long)1024L, (long)this.mCacheManager.get(PAGE_ID, 1024, this.mBuffer, 0));
        Assert.assertArrayEquals((byte[])PAGE, (byte[])this.mBuffer);
        Assert.assertFalse((boolean)FileUtils.exists((String)invalidPageFileName));
    }

    @Test
    public void loadCacheLargerNewCacheSize() throws Exception {
        this.testLoadCacheConfChanged(PropertyKey.USER_CLIENT_CACHE_SIZE, String.valueOf(65536));
        this.testPageCached();
    }

    private void testLoadCacheConfChanged(PropertyKey prop, Object value) throws Exception {
        this.mCacheManagerOptions = CacheManagerOptions.create((AlluxioConfiguration)this.mConf);
        this.mPageMetaStore = PageMetaStore.create((CacheManagerOptions)this.mCacheManagerOptions);
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        this.mCacheManager.put(PAGE_ID, PAGE);
        this.testPageCached();
        this.mCacheManager.close();
        this.mConf.set(prop, value);
        this.mCacheManagerOptions = CacheManagerOptions.create((AlluxioConfiguration)this.mConf);
        this.mPageMetaStore = PageMetaStore.create((CacheManagerOptions)this.mCacheManagerOptions);
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
    }

    private void testLoadCacheConfMismatch(PropertyKey prop, Object value) throws Exception {
        this.testLoadCacheConfChanged(prop, value);
        Assert.assertEquals((long)0L, (long)this.mCacheManager.get(PAGE_ID, 1024, this.mBuffer, 0));
    }

    private void loadFullCache() throws Exception {
        int i;
        this.mCacheManager = LocalCacheManager.create((CacheManagerOptions)this.mCacheManagerOptions, (PageMetaStore)this.mPageMetaStore);
        for (i = 0; i < 32; ++i) {
            this.mCacheManager.put(new PageId("0", (long)i), PAGE);
        }
        for (i = 0; i < 32; ++i) {
            this.testPageCached(new PageId("0", (long)i));
        }
    }
}

