/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.io.AbstractFileOutStreamIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.file.meta.PersistenceState;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="check if this feature is still relevant")
public final class PersistMultipleMountsIntegrationTest
extends AbstractFileOutStreamIntegrationTest {
    private static final String MOUNT_PATH = "/mounted";
    @Rule
    public TemporaryFolder mTempFolder = new TemporaryFolder();
    private String mUfsRoot;
    private UnderFileSystem mUfs;
    private String mMountedUfsRoot;
    private UnderFileSystem mMountedUfs;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.mUfsRoot = PathUtils.concatPath((Object)Configuration.get((PropertyKey)PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS), (Object[])new Object[0]);
        this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsRoot, (AlluxioConfiguration)Configuration.global());
        this.mMountedUfsRoot = this.mTempFolder.getRoot().getAbsolutePath();
        this.mFileSystem.mount(new AlluxioURI(MOUNT_PATH), new AlluxioURI(this.mMountedUfsRoot));
        this.mMountedUfs = UnderFileSystem.Factory.create((String)this.mMountedUfsRoot, (AlluxioConfiguration)Configuration.global());
    }

    @Test
    public void syncMultipleMountsDefaultPersist() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)this.mUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)this.mUfs) ? 1 : 0) != 0);
        String path = PathUtils.uniqPath();
        AlluxioURI filePath = new AlluxioURI(path);
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertTrue((boolean)this.mUfs.exists(PathUtils.concatPath((Object)this.mUfsRoot, (Object)path)));
        Assert.assertFalse((boolean)this.mMountedUfs.exists(PathUtils.concatPath((Object)this.mMountedUfsRoot, (Object)path)));
    }

    @Test
    public void syncMultipleMountsMountedPersist() throws Exception {
        Assume.assumeTrue((UnderFileSystemUtils.isLocal((UnderFileSystem)this.mUfs) || UnderFileSystemUtils.isHdfs((UnderFileSystem)this.mUfs) ? 1 : 0) != 0);
        String path = PathUtils.uniqPath();
        AlluxioURI filePath = new AlluxioURI(MOUNT_PATH + path);
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertFalse((boolean)this.mUfs.exists(PathUtils.concatPath((Object)this.mUfsRoot, (Object)path)));
        Assert.assertTrue((boolean)this.mMountedUfs.exists(PathUtils.concatPath((Object)this.mMountedUfsRoot, (Object)path)));
    }
}

