/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PreconditionMessage;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.security.user.UserState;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import javax.security.auth.Subject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix tests here")
public class RemoteReadIntegrationTest
extends BaseIntegrationTest {
    private static final int MIN_LEN = 0;
    private static final int MAX_LEN = 255;
    private static final int DELTA = 33;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource;
    private FileSystem mFileSystem = null;
    private FileSystemContext mFsContext;
    private CreateFilePOptions mWriteAlluxio;
    private CreateFilePOptions mWriteUnderStore;
    private OpenFilePOptions mReadNoCache;
    private OpenFilePOptions mReadCache;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    public RemoteReadIntegrationTest() {
        this.mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_UFS_BLOCK_READ_CONCURRENCY_MAX, 2).build();
    }

    @Before
    public final void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        UserState us = UserState.Factory.create((AlluxioConfiguration)Configuration.global());
        this.mFsContext = FileSystemContext.create((Subject)us.getSubject(), (AlluxioConfiguration)Configuration.global());
        this.mWriteAlluxio = CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build();
        this.mWriteUnderStore = CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build();
        this.mReadCache = OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE_PROMOTE).build();
        this.mReadNoCache = OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build();
    }

    @After
    public void after() throws Exception {
        this.mFsContext.close();
    }

    @Test
    public void readTest1() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            byte[] ret = new byte[k];
            int value = is.read();
            int cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = is.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            if (k == 0) {
                FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            } else {
                Assert.assertNotEquals((long)100L, (long)this.mFileSystem.getStatus(uri).getInAlluxioPercentage());
            }
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            value = is.read();
            cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = is.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            value = is.read();
            cnt = 0;
            while (value != -1) {
                Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                ret[cnt++] = (byte)value;
                value = is.read();
            }
            Assert.assertEquals((long)cnt, (long)k);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
        }
    }

    @Test
    public void readTest2() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            byte[] ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            if (k == 0) {
                FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            } else {
                Assert.assertFalse((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
        }
    }

    @Test
    public void readTest3() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            byte[] ret = new byte[k / 2];
            Assert.assertEquals((long)(k / 2), (long)is.read(ret, 0, k / 2));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(k / 2), (byte[])ret));
            is.close();
            if (k == 0) {
                FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            } else {
                Assert.assertFalse((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret, 0, k));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            is.close();
            FileSystemUtils.waitForAlluxioPercentage((FileSystem)this.mFileSystem, (AlluxioURI)uri, (int)100);
        }
    }

    @Test
    public void readTest7() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 33; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            byte[] ret = new byte[k];
            Assert.assertEquals((long)k, (long)is.read(ret));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
            Assert.assertEquals((long)-1L, (long)is.read(ret));
            is.close();
            Assert.assertFalse((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        }
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.worker.network.keepalive.time", "1sec"})
    public void heartbeat1() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int size = 100;
        AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + size);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)size);
        FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
        CommonUtils.sleepMs((long)2000L);
        byte[] ret = new byte[size];
        Assert.assertEquals((long)size, (long)is.read(ret));
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)size, (byte[])ret));
        Assert.assertEquals((long)-1L, (long)is.read(ret));
        is.close();
        Assert.assertFalse((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
    }

    @Test
    public void seekExceptionTest1() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_NEGATIVE.toString(), -1));
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            try (FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);){
                is.seek(-1L);
                continue;
            }
        }
    }

    @Test
    public void seekExceptionTest2() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_PAST_END_OF_FILE.toString(), 1));
        String uniqPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            try (FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);){
                is.seek((long)(k + 1));
                continue;
            }
        }
    }

    @Test
    public void seek() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 33; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
            Assert.assertEquals((long)0L, (long)is.read());
            is.seek((long)(k / 3));
            Assert.assertEquals((long)(k / 3), (long)is.read());
            is.seek((long)(k / 2));
            Assert.assertEquals((long)(k / 2), (long)is.read());
            is.seek((long)(k / 4));
            Assert.assertEquals((long)(k / 4), (long)is.read());
            is.close();
        }
    }

    @Test
    public void skip() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        for (int k = 33; k <= 255; k += 33) {
            AlluxioURI uri = new AlluxioURI(uniqPath + "/file_" + k);
            FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)k);
            FileInStream is = this.mFileSystem.openFile(uri, this.mReadCache);
            Assert.assertEquals((long)(k / 2), (long)is.skip((long)(k / 2)));
            Assert.assertEquals((long)(k / 2), (long)is.read());
            is.close();
            IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
            if (k < 3) continue;
            is = this.mFileSystem.openFile(uri, this.mReadCache);
            int t = k / 3;
            Assert.assertEquals((long)t, (long)is.skip((long)t));
            Assert.assertEquals((long)t, (long)is.read());
            Assert.assertEquals((long)t, (long)is.skip((long)t));
            Assert.assertEquals((long)(2 * t + 1), (long)is.read());
            is.close();
            IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
        }
    }

    @Test
    public void completeFileReadTriggersRecache() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int len = 2;
        AlluxioURI uri = new AlluxioURI(uniqPath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)len);
        FileInStream is = this.mFileSystem.openFile(uri, this.mReadCache);
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((long)i, (long)is.read());
        }
        is.close();
        IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
    }

    @Test
    public void incompleteFileReadCancelsRecache() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        AlluxioURI uri = new AlluxioURI(uniqPath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)uri, (CreateFilePOptions)this.mWriteUnderStore, (int)2);
        FileInStream is = this.mFileSystem.openFile(uri, this.mReadNoCache);
        Assert.assertEquals((long)0L, (long)is.read());
        is.close();
        Assert.assertFalse((this.mFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
        is = this.mFileSystem.openFile(uri, this.mReadNoCache);
        is.close();
    }

    @Test
    public void readMultiBlockFile() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        int blockSizeByte = 10;
        int numBlocks = 10;
        AlluxioURI uri = new AlluxioURI(uniqPath);
        FileOutStream os = this.mFileSystem.createFile(uri, this.mWriteUnderStore);
        for (int i = 0; i < numBlocks; ++i) {
            for (int j = 0; j < blockSizeByte; ++j) {
                os.write((int)((byte)(i * blockSizeByte + j)));
            }
        }
        os.close();
        FileInStream is = this.mFileSystem.openFile(uri, this.mReadCache);
        for (int i = 0; i < blockSizeByte * numBlocks; ++i) {
            Assert.assertEquals((long)((byte)i), (long)is.read());
        }
        is.close();
        IntegrationTestUtils.waitForFileCached(this.mFileSystem, uri, 1000);
    }

    @Test
    public void seekAroundLocalBlock() throws Exception {
        String uniqPath = PathUtils.uniqPath();
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)uniqPath, (int)200, (CreateFilePOptions)this.mWriteAlluxio);
        FileInStream is = this.mFileSystem.openFile(new AlluxioURI(uniqPath), this.mReadNoCache);
        Assert.assertEquals((long)0L, (long)is.read());
        is.seek(199L);
        Assert.assertEquals((long)199L, (long)is.read());
        is.seek(99L);
        Assert.assertEquals((long)99L, (long)is.read());
        is.close();
    }
}

