/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.concurrent.ConcurrentFileSystemMasterUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.io.Files;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="redefine behaviors")
public class ConcurrentDeleteIntegrationTest
extends BaseIntegrationTest {
    private static final String TEST_USER = "test";
    private static final int CONCURRENCY_FACTOR = 50;
    private static final long SLEEP_MS = 1000L;
    private static final long LIMIT_MS = 25000L;
    private static CreateFilePOptions sCreatePersistedFileOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).build();
    private static CreateDirectoryPOptions sCreatePersistedDirOptions = CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.THROUGH).build();
    private FileSystem mFileSystem;
    private String mLocalUfsPath = Files.createTempDir().getAbsolutePath();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "sleep://" + this.mLocalUfsPath).setProperty(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX, 50).build();
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setMkdirsMs(1000L).setIsDirectoryMs(1000L)));

    @Before
    public void before() {
        this.mFileSystem = FileSystem.Factory.create();
    }

    @Test
    public void rootConcurrentDelete() throws Exception {
        int numThreads = 50;
        AlluxioURI[] paths = new AlluxioURI[50];
        for (int i = 0; i < 50; ++i) {
            paths[i] = new AlluxioURI("/file" + i);
            this.mFileSystem.createFile(paths[i], sCreatePersistedFileOptions).close();
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.DELETE, paths, 25000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)0L, (long)files.size());
    }

    @Test
    public void folderConcurrentDelete() throws Exception {
        int numThreads = 50;
        AlluxioURI[] paths = new AlluxioURI[50];
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        for (int i = 0; i < 50; ++i) {
            paths[i] = dir.join("/file" + i);
            this.mFileSystem.createFile(paths[i], sCreatePersistedFileOptions).close();
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.DELETE, paths, 25000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
        List files = this.mFileSystem.listStatus(dir);
        Assert.assertEquals((long)0L, (long)files.size());
    }

    @Test
    public void prefixConcurrentDelete() throws Exception {
        int numThreads = 50;
        AlluxioURI[] paths = new AlluxioURI[50];
        AlluxioURI dir1 = new AlluxioURI("/dir1");
        this.mFileSystem.createDirectory(dir1);
        AlluxioURI dir2 = new AlluxioURI("/dir1/dir2");
        this.mFileSystem.createDirectory(dir2);
        AlluxioURI dir3 = new AlluxioURI("/dir1/dir2/dir3");
        this.mFileSystem.createDirectory(dir3);
        for (int i = 0; i < 50; ++i) {
            paths[i] = i % 3 == 0 ? dir1.join("/file" + i) : (i % 3 == 1 ? dir2.join("/file" + i) : dir3.join("/file" + i));
            this.mFileSystem.createFile(paths[i], sCreatePersistedFileOptions).close();
        }
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.DELETE, paths, 25000L);
        if (!errors.isEmpty()) {
            Assert.fail((String)("Encountered " + errors.size() + " errors, the first one is " + errors.get(0)));
        }
        List files = this.mFileSystem.listStatus(dir1);
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)"dir2", (Object)((URIStatus)files.get(0)).getName());
        files = this.mFileSystem.listStatus(dir2);
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)"dir3", (Object)((URIStatus)files.get(0)).getName());
        files = this.mFileSystem.listStatus(dir3);
        Assert.assertEquals((long)0L, (long)files.size());
    }

    @Test
    public void sameFileConcurrentDelete() throws Exception {
        int numThreads = 50;
        AlluxioURI[] paths = new AlluxioURI[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            paths[i] = new AlluxioURI("/file");
        }
        this.mFileSystem.createFile(paths[0], sCreatePersistedFileOptions).close();
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.DELETE, paths, 25000L);
        Assert.assertEquals((long)(numThreads - 1), (long)errors.size());
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)0L, (long)files.size());
    }

    @Test
    public void sameDirConcurrentDelete() throws Exception {
        int numThreads = 50;
        AlluxioURI[] paths = new AlluxioURI[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            paths[i] = new AlluxioURI("/dir");
        }
        this.mFileSystem.createDirectory(paths[0], sCreatePersistedDirOptions);
        List<Throwable> errors = ConcurrentFileSystemMasterUtils.unaryOperation(this.mFileSystem, ConcurrentFileSystemMasterUtils.UnaryOperation.DELETE, paths, 25000L);
        Assert.assertEquals((long)(numThreads - 1), (long)errors.size());
        List dirs = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)0L, (long)dirs.size());
    }
}

