/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.test.util.ConcurrencyUtils;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.PathUtils;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="redefine behaviors")
public final class ConcurrentFileInStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int BLOCK_SIZE = 30;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT, "20s").build();
    private FileSystem mFileSystem;

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @Test
    public void FileInStreamConcurrency() throws Exception {
        int numReadThreads = Configuration.getInt((PropertyKey)PropertyKey.USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX) * 10;
        AlluxioURI uniqPath = new AlluxioURI(PathUtils.uniqPath());
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)uniqPath.getPath(), (int)60, (CreateFilePOptions)CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build());
        ArrayList<FileRead> threads = new ArrayList<FileRead>();
        for (int i = 0; i < numReadThreads; ++i) {
            threads.add(new FileRead(uniqPath));
        }
        ConcurrencyUtils.assertConcurrent(threads, (int)100);
    }

    class FileRead
    implements Runnable {
        private final AlluxioURI mUri;

        FileRead(AlluxioURI uri) {
            this.mUri = uri;
        }

        @Override
        public void run() {
            try (FileInStream stream = ConcurrentFileInStreamIntegrationTest.this.mFileSystem.openFile(this.mUri);){
                stream.read();
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

