/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.collections.ConcurrentHashSet;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.TtlAction;
import alluxio.grpc.WritePType;
import alluxio.heartbeat.HeartbeatScheduler;
import alluxio.heartbeat.ManuallyScheduleHeartbeat;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="redefine behaviors")
public class ConcurrentFileSystemMasterSetTtlIntegrationTest
extends BaseIntegrationTest {
    private static final String TEST_USER = "test";
    private static final int CONCURRENCY_FACTOR = 50;
    private static final long SLEEP_MS = 1000L;
    private static final long LIMIT_MS = 25000L;
    private static final int TTL_INTERVAL_MS = 100;
    private FileSystem mFileSystem;
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @ClassRule
    public static ManuallyScheduleHeartbeat sManuallySchedule = new ManuallyScheduleHeartbeat(new String[]{"Master TTL Check"});
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_TTL_CHECKER_INTERVAL_MS, 100).setProperty(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX, 50).setProperty(PropertyKey.USER_BLOCK_MASTER_CLIENT_POOL_SIZE_MAX, 50).setProperty(PropertyKey.MASTER_RPC_EXECUTOR_CORE_POOL_SIZE, 50).build();

    @Before
    public void before() {
        this.mFileSystem = FileSystem.Factory.create();
    }

    @Test
    public void rootFileConcurrentSetTtlTest() throws Exception {
        int numThreads = 50;
        AlluxioURI[] files = new AlluxioURI[50];
        long[] ttls = new long[50];
        Random random = new Random();
        for (int i = 0; i < 50; ++i) {
            files[i] = new AlluxioURI("/file" + i);
            this.mFileSystem.createFile(files[i], CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build()).close();
            ttls[i] = random.nextInt(200);
        }
        this.assertErrorsSizeEquals(this.concurrentSetTtl(files, ttls), 0);
        CommonUtils.sleepMs((long)400L);
        HeartbeatScheduler.execute((String)"Master TTL Check");
        Assert.assertEquals((String)"There are remaining file existing with expired TTLs", (long)0L, (long)this.mFileSystem.listStatus(new AlluxioURI("/")).size());
    }

    private ConcurrentHashSet<Throwable> concurrentSetTtl(final AlluxioURI[] paths, final long[] ttls) throws Exception {
        int numFiles = paths.length;
        final CyclicBarrier barrier = new CyclicBarrier(numFiles);
        ArrayList<Object> threads = new ArrayList<Object>(numFiles);
        final ConcurrentHashSet errors = new ConcurrentHashSet();
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                errors.add((Object)ex);
            }
        };
        int i = 0;
        while (i < numFiles) {
            final int iteration = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AuthenticatedClientUser.set((String)ConcurrentFileSystemMasterSetTtlIntegrationTest.TEST_USER);
                        barrier.await();
                        ConcurrentFileSystemMasterSetTtlIntegrationTest.this.mFileSystem.setAttribute(paths[iteration], SetAttributePOptions.newBuilder().setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(ttls[iteration]).setTtlAction(TtlAction.DELETE)).build());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            t.setUncaughtExceptionHandler(exceptionHandler);
            threads.add(t);
        }
        Collections.shuffle(threads);
        long startMs = CommonUtils.getCurrentMs();
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        long durationMs = CommonUtils.getCurrentMs() - startMs;
        Assert.assertTrue((String)("Execution duration " + durationMs + " took longer than expected " + 25000L), (durationMs < 25000L ? 1 : 0) != 0);
        return errors;
    }

    private void assertErrorsSizeEquals(ConcurrentHashSet<Throwable> errors, int expected) {
        if (errors.size() != expected) {
            Assert.fail((String)(String.format("Expected %d errors, but got %d, errors:\n", expected, errors.size()) + Joiner.on((String)"\n").join(errors)));
        }
    }

    @Test
    public void testConcurrentInsertAndExpire() throws Exception {
        String fileNamePrefix = "file";
        AlluxioURI fileUri1 = new AlluxioURI("/" + fileNamePrefix + "1");
        final AlluxioURI fileUri2 = new AlluxioURI("/" + fileNamePrefix + "2");
        this.mFileSystem.createFile(fileUri1, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        this.mFileSystem.createFile(fileUri2, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build());
        SetAttributePOptions setTTlOptions = SetAttributePOptions.newBuilder().setRecursive(false).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(100L).setTtlAction(TtlAction.DELETE).build()).build();
        this.mFileSystem.setAttribute(fileUri1, setTTlOptions);
        CommonUtils.sleepMs((long)400L);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        ArrayList<Thread> threads = new ArrayList<Thread>(2);
        final ConcurrentHashSet errors = new ConcurrentHashSet();
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                errors.add((Object)ex);
            }
        };
        Thread ttlCheckerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AuthenticatedClientUser.set((String)ConcurrentFileSystemMasterSetTtlIntegrationTest.TEST_USER);
                    barrier.await();
                    HeartbeatScheduler.execute((String)"Master TTL Check");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ttlCheckerThread.setUncaughtExceptionHandler(exceptionHandler);
        threads.add(ttlCheckerThread);
        Thread setTtlFile2Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AuthenticatedClientUser.set((String)ConcurrentFileSystemMasterSetTtlIntegrationTest.TEST_USER);
                    barrier.await();
                    SetAttributePOptions setTTlOptions = SetAttributePOptions.newBuilder().setRecursive(false).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setTtl(100L).setTtlAction(TtlAction.DELETE).build()).build();
                    ConcurrentFileSystemMasterSetTtlIntegrationTest.this.mFileSystem.setAttribute(fileUri2, setTTlOptions);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        setTtlFile2Thread.setUncaughtExceptionHandler(exceptionHandler);
        threads.add(setTtlFile2Thread);
        Collections.shuffle(threads);
        long startMs = CommonUtils.getCurrentMs();
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        List fileStatus = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertTrue((String)String.format("file1:{} still exists and didn't get expired.", fileUri1.getPath()), (!fileStatus.stream().anyMatch(status -> new AlluxioURI(status.getFileInfo().getPath()).equals((Object)fileUri1)) ? 1 : 0) != 0);
        if (fileStatus.stream().anyMatch(status -> new AlluxioURI(status.getFileInfo().getPath()).equals((Object)fileUri2))) {
            Assert.assertTrue((((URIStatus)fileStatus.get(0)).getFileInfo().getTtl() == 100L ? 1 : 0) != 0);
            HeartbeatScheduler.execute((String)"Master TTL Check");
            Assert.assertEquals((String)"There are remaining file existing with expired TTLs", (long)0L, (long)this.mFileSystem.listStatus(new AlluxioURI("/")).size());
        }
    }
}

