/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.util.CommonUtils;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class ConcurrentFileSystemMasterUtils {
    private static final String TEST_USER = "test";
    private static CreateFilePOptions sCreatePersistedFileOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build();

    public static List<Throwable> unaryOperation(final FileSystem fileSystem, final UnaryOperation operation, final AlluxioURI[] paths, long limitMs) throws Exception {
        int numFiles = paths.length;
        final CyclicBarrier barrier = new CyclicBarrier(numFiles);
        ArrayList<Object> threads = new ArrayList<Object>(numFiles);
        List<Throwable> errors = Collections.synchronizedList(new ArrayList());
        Thread.UncaughtExceptionHandler exceptionHandler = (th, ex) -> errors.add(ex);
        int i = 0;
        while (i < numFiles) {
            final int iteration = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AuthenticatedClientUser.set((String)ConcurrentFileSystemMasterUtils.TEST_USER);
                        barrier.await();
                        switch (operation) {
                            case CREATE: {
                                fileSystem.createFile(paths[iteration], sCreatePersistedFileOptions).close();
                                break;
                            }
                            case DELETE: {
                                fileSystem.delete(paths[iteration]);
                                break;
                            }
                            case GET_FILE_INFO: {
                                URIStatus status = fileSystem.getStatus(paths[iteration]);
                                if (!status.isFolder()) {
                                    Assert.assertNotEquals((long)0L, (long)status.getBlockIds().size());
                                }
                                break;
                            }
                            case LIST_STATUS: {
                                fileSystem.listStatus(paths[iteration]);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("'operation' is not a valid operation.");
                            }
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            });
            t.setUncaughtExceptionHandler(exceptionHandler);
            threads.add(t);
        }
        Collections.shuffle(threads);
        long startMs = CommonUtils.getCurrentMs();
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        long durationMs = CommonUtils.getCurrentMs() - startMs;
        Assert.assertTrue((String)("Execution duration " + durationMs + " took longer than expected " + limitMs), (durationMs < limitMs ? 1 : 0) != 0);
        return errors;
    }

    public static class IntegerSuffixedPathComparator
    implements Comparator<URIStatus> {
        @Override
        public int compare(URIStatus o1, URIStatus o2) {
            return this.extractIntegerSuffix(o1.getName()) - this.extractIntegerSuffix(o2.getName());
        }

        private int extractIntegerSuffix(String name) {
            Pattern p = Pattern.compile("\\D*(\\d+$)");
            Matcher m = p.matcher(name);
            if (m.matches()) {
                return Integer.parseInt(m.group(1));
            }
            return Integer.MAX_VALUE;
        }
    }

    public static enum UnaryOperation {
        CREATE,
        DELETE,
        GET_FILE_INFO,
        LIST_STATUS;

    }
}

