/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.concurrent;

import alluxio.AlluxioURI;
import alluxio.AuthenticatedUserRule;
import alluxio.UnderFileSystemFactoryRegistryRule;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.concurrent.ConcurrentFileSystemMasterUtils;
import alluxio.collections.ConcurrentHashSet;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemFactory;
import alluxio.testutils.underfs.sleeping.SleepingUnderFileSystemOptions;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.util.CommonUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiacheng", comment="redefine behaviors")
public class ConcurrentRenameIntegrationTest
extends BaseIntegrationTest {
    private static final String TEST_USER = "test";
    private static final int CONCURRENCY_FACTOR = 50;
    private static final long SLEEP_MS = 100L;
    private static final long LIMIT_MS = 2500L;
    private static CreateFilePOptions sCreatePersistedFileOptions = CreateFilePOptions.newBuilder().setWriteType(WritePType.THROUGH).build();
    private static CreateDirectoryPOptions sCreatePersistedDirOptions = CreateDirectoryPOptions.newBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build();
    private FileSystem mFileSystem;
    private String mLocalUfsPath = Files.createTempDir().getAbsolutePath();
    @Rule
    public AuthenticatedUserRule mAuthenticatedUser = new AuthenticatedUserRule("test", Configuration.global());
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "sleep://" + this.mLocalUfsPath).setProperty(PropertyKey.USER_FILE_MASTER_CLIENT_POOL_SIZE_MAX, 50).build();
    @ClassRule
    public static UnderFileSystemFactoryRegistryRule sUnderfilesystemfactoryregistry = new UnderFileSystemFactoryRegistryRule((UnderFileSystemFactory)new SleepingUnderFileSystemFactory(new SleepingUnderFileSystemOptions().setMkdirsMs(100L).setIsDirectoryMs(100L)));

    @Before
    public void before() {
        this.mFileSystem = FileSystem.Factory.create();
    }

    @Test
    public void rootConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[50];
        AlluxioURI[] dsts = new AlluxioURI[50];
        for (int i = 0; i < 50; ++i) {
            srcs[i] = new AlluxioURI("/file" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
            dsts[i] = new AlluxioURI("/renamed" + i);
        }
        this.assertErrorsSizeEquals(this.concurrentRename(srcs, dsts), 0);
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Collections.sort(files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)files.get(i)).getName());
        }
        Assert.assertEquals((long)50L, (long)files.size());
    }

    @Test
    public void folderConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[50];
        AlluxioURI[] dsts = new AlluxioURI[50];
        AlluxioURI dir = new AlluxioURI("/dir");
        this.mFileSystem.createDirectory(dir);
        for (int i = 0; i < 50; ++i) {
            srcs[i] = dir.join("/file" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
            dsts[i] = dir.join("/renamed" + i);
        }
        this.assertErrorsSizeEquals(this.concurrentRename(srcs, dsts), 0);
        List files = this.mFileSystem.listStatus(new AlluxioURI("/dir"));
        Collections.sort(files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)files.get(i)).getName());
        }
        Assert.assertEquals((long)50L, (long)files.size());
    }

    @Test
    public void sameFileConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = new AlluxioURI("/file");
            dsts[i] = new AlluxioURI("/renamed" + i);
        }
        this.mFileSystem.createFile(srcs[0], sCreatePersistedFileOptions).close();
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        Assert.assertEquals((long)(numThreads - 1), (long)errors.size());
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertTrue((boolean)((URIStatus)files.get(0)).getName().startsWith("renamed"));
    }

    @Test
    public void sameDirConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = new AlluxioURI("/dir");
            dsts[i] = new AlluxioURI("/renamed" + i);
        }
        this.mFileSystem.createDirectory(srcs[0]);
        this.mFileSystem.createFile(new AlluxioURI("/dir/file"), sCreatePersistedFileOptions).close();
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, numThreads - 1);
        List existingDirs = this.mFileSystem.listStatus(new AlluxioURI("/"));
        Assert.assertEquals((long)1L, (long)existingDirs.size());
        Assert.assertTrue((boolean)((URIStatus)existingDirs.get(0)).getName().startsWith("renamed"));
        List dirChildren = this.mFileSystem.listStatus(new AlluxioURI(((URIStatus)existingDirs.get(0)).getPath()));
        Assert.assertEquals((long)1L, (long)dirChildren.size());
    }

    @Test
    public void sameDstConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = new AlluxioURI("/file" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
            dsts[i] = new AlluxioURI("/renamed");
        }
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, numThreads - 1);
        List files = this.mFileSystem.listStatus(new AlluxioURI("/"));
        HashSet<String> renamedFiles = new HashSet<String>();
        HashSet<String> originalFiles = new HashSet<String>();
        for (URIStatus file : files) {
            if (file.getName().startsWith("renamed")) {
                renamedFiles.add(file.getName());
            }
            if (!file.getName().startsWith("file")) continue;
            originalFiles.add(file.getName());
        }
        Assert.assertEquals((long)numThreads, (long)files.size());
        Assert.assertEquals((long)1L, (long)renamedFiles.size());
        Assert.assertEquals((long)(numThreads - 1), (long)originalFiles.size());
    }

    @Test
    public void twoDirConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        AlluxioURI dir1 = new AlluxioURI("/dir1");
        AlluxioURI dir2 = new AlluxioURI("/dir2");
        this.mFileSystem.createDirectory(dir1);
        this.mFileSystem.createDirectory(dir2);
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = dir1.join("file" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
            dsts[i] = dir2.join("renamed" + i);
        }
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, 0);
        List dir1Files = this.mFileSystem.listStatus(dir1);
        List dir2Files = this.mFileSystem.listStatus(dir2);
        Assert.assertEquals((long)0L, (long)dir1Files.size());
        Assert.assertEquals((long)numThreads, (long)dir2Files.size());
        Collections.sort(dir2Files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < numThreads; ++i) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)dir2Files.get(i)).getName());
        }
    }

    @Test
    public void acrossDirConcurrentRename() throws Exception {
        int i;
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        AlluxioURI dir1 = new AlluxioURI("/dir1");
        AlluxioURI dir2 = new AlluxioURI("/dir2");
        this.mFileSystem.createDirectory(dir1);
        this.mFileSystem.createDirectory(dir2);
        for (int i2 = 0; i2 < numThreads; ++i2) {
            if (i2 % 2 == 0) {
                srcs[i2] = dir1.join("file" + i2);
                dsts[i2] = dir2.join("renamed" + i2);
            } else {
                srcs[i2] = dir2.join("file" + i2);
                dsts[i2] = dir1.join("renamed" + i2);
            }
            this.mFileSystem.createFile(srcs[i2], sCreatePersistedFileOptions).close();
        }
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, 0);
        List dir1Files = this.mFileSystem.listStatus(dir1);
        List dir2Files = this.mFileSystem.listStatus(dir2);
        Assert.assertEquals((long)(numThreads / 2), (long)dir1Files.size());
        Assert.assertEquals((long)(numThreads / 2), (long)dir2Files.size());
        Collections.sort(dir1Files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (i = 1; i < numThreads; i += 2) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)dir1Files.get(i / 2)).getName());
        }
        Collections.sort(dir2Files, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (i = 0; i < numThreads; i += 2) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)dir2Files.get(i / 2)).getName());
        }
    }

    @Test
    public void sharedPrefixDirConcurrentRename() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        AlluxioURI dir1 = new AlluxioURI("/root/dir1");
        AlluxioURI dir2 = new AlluxioURI("/root/parent/dir2");
        AlluxioURI dst = new AlluxioURI("/dst");
        this.mFileSystem.createDirectory(dir1, sCreatePersistedDirOptions);
        this.mFileSystem.createDirectory(dir2, sCreatePersistedDirOptions);
        this.mFileSystem.createDirectory(dst, sCreatePersistedDirOptions);
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = i % 2 == 0 ? dir1.join("file" + i) : dir2.join("file" + i);
            dsts[i] = dst.join("renamed" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
        }
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, 0);
        List dir1Files = this.mFileSystem.listStatus(dir1);
        List dir2Files = this.mFileSystem.listStatus(dir2);
        List dstFiles = this.mFileSystem.listStatus(dst);
        Assert.assertEquals((long)0L, (long)dir1Files.size());
        Assert.assertEquals((long)0L, (long)dir2Files.size());
        Assert.assertEquals((long)numThreads, (long)dstFiles.size());
        Collections.sort(dstFiles, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < numThreads; ++i) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)dstFiles.get(i)).getName());
        }
    }

    @Test
    public void sharedPrefixDirConcurrentRenameNonPersisted() throws Exception {
        int numThreads = 50;
        AlluxioURI[] srcs = new AlluxioURI[numThreads];
        AlluxioURI[] dsts = new AlluxioURI[numThreads];
        AlluxioURI dir1 = new AlluxioURI("/root/dir1");
        AlluxioURI dir2 = new AlluxioURI("/root/parent/dir2");
        AlluxioURI dst = new AlluxioURI("/dst");
        this.mFileSystem.createDirectory(dir1, CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.mFileSystem.createDirectory(dir2, CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.mFileSystem.createDirectory(dst, CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        for (int i = 0; i < numThreads; ++i) {
            srcs[i] = i % 2 == 0 ? dir1.join("file" + i) : dir2.join("file" + i);
            dsts[i] = dst.join("renamed" + i);
            this.mFileSystem.createFile(srcs[i], sCreatePersistedFileOptions).close();
        }
        ConcurrentHashSet<Throwable> errors = this.concurrentRename(srcs, dsts);
        this.assertErrorsSizeEquals(errors, 0);
        List dir1Files = this.mFileSystem.listStatus(dir1);
        List dir2Files = this.mFileSystem.listStatus(dir2);
        List dstFiles = this.mFileSystem.listStatus(dst);
        Assert.assertEquals((long)0L, (long)dir1Files.size());
        Assert.assertEquals((long)0L, (long)dir2Files.size());
        Assert.assertEquals((long)numThreads, (long)dstFiles.size());
        Collections.sort(dstFiles, new ConcurrentFileSystemMasterUtils.IntegerSuffixedPathComparator());
        for (int i = 0; i < numThreads; ++i) {
            Assert.assertEquals((Object)dsts[i].getName(), (Object)((URIStatus)dstFiles.get(i)).getName());
        }
    }

    private void assertErrorsSizeEquals(ConcurrentHashSet<Throwable> errors, int expected) {
        if (errors.size() != expected) {
            Assert.fail((String)(String.format("Expected %d errors, but got %d, errors:\n", expected, errors.size()) + Joiner.on((String)"\n").join(errors)));
        }
    }

    private ConcurrentHashSet<Throwable> concurrentRename(final AlluxioURI[] src, final AlluxioURI[] dst) throws Exception {
        int numFiles = src.length;
        final CyclicBarrier barrier = new CyclicBarrier(numFiles);
        ArrayList<Object> threads = new ArrayList<Object>(numFiles);
        final ConcurrentHashSet errors = new ConcurrentHashSet();
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                errors.add((Object)ex);
            }
        };
        int i = 0;
        while (i < numFiles) {
            final int iteration = i++;
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AuthenticatedClientUser.set((String)ConcurrentRenameIntegrationTest.TEST_USER);
                        barrier.await();
                        ConcurrentRenameIntegrationTest.this.mFileSystem.rename(src[iteration], dst[iteration]);
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            });
            t.setUncaughtExceptionHandler(exceptionHandler);
            threads.add(t);
        }
        Collections.shuffle(threads);
        long startMs = CommonUtils.getCurrentMs();
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        long durationMs = CommonUtils.getCurrentMs() - startMs;
        Assert.assertTrue((String)("Execution duration " + durationMs + " took longer than expected " + 2500L), (durationMs < 2500L ? 1 : 0) != 0);
        return errors;
    }

    @Test
    public void consistentGetFileInfo() throws Exception {
        int iterations = 50;
        final AlluxioURI file = new AlluxioURI("/file");
        final AlluxioURI dst = new AlluxioURI("/dst");
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final ConcurrentHashSet errors = new ConcurrentHashSet();
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                errors.add((Object)ex);
            }
        };
        for (int i = 0; i < 50; ++i) {
            this.mFileSystem.createFile(file, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).build()).close();
            Thread renamer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AuthenticatedClientUser.set((String)ConcurrentRenameIntegrationTest.TEST_USER);
                        barrier.await();
                        ConcurrentRenameIntegrationTest.this.mFileSystem.rename(file, dst);
                        ConcurrentRenameIntegrationTest.this.mFileSystem.delete(dst);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
            renamer.setUncaughtExceptionHandler(exceptionHandler);
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AuthenticatedClientUser.set((String)ConcurrentRenameIntegrationTest.TEST_USER);
                        barrier.await();
                        URIStatus status = ConcurrentRenameIntegrationTest.this.mFileSystem.getStatus(file);
                        Assert.assertEquals((Object)file.getName(), (Object)status.getName());
                    }
                    catch (AlluxioException status) {
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            });
            reader.setUncaughtExceptionHandler(exceptionHandler);
            renamer.start();
            reader.start();
            renamer.join();
            reader.join();
            Assert.assertTrue((String)("Errors detected: " + errors), (boolean)errors.isEmpty());
        }
    }
}

