/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.master.LocalAlluxioJobCluster;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.io.BufferUtils;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractFileOutStreamIntegrationTest
extends BaseIntegrationTest {
    protected static final int MIN_LEN = 0;
    protected static final int MAX_LEN = 255;
    protected static final int DELTA = 32;
    protected static final int BUFFER_BYTES = 100;
    protected LocalAlluxioJobCluster mLocalAlluxioJobCluster;
    protected static final int BLOCK_SIZE_BYTES = 1000;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = this.buildLocalAlluxioClusterResource();
    protected FileSystem mFileSystem = null;

    @Before
    public void before() throws Exception {
        this.mLocalAlluxioJobCluster = new LocalAlluxioJobCluster();
        this.mLocalAlluxioJobCluster.start();
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
    }

    @After
    public void after() throws Exception {
        if (this.mLocalAlluxioJobCluster != null) {
            this.mLocalAlluxioJobCluster.stop();
        }
    }

    protected void customizeClusterResource(LocalAlluxioClusterResource.Builder resource) {
        resource.setProperty(PropertyKey.USER_FILE_BUFFER_BYTES, 100).setProperty(PropertyKey.USER_FILE_REPLICATION_DURABLE, 1).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 1000);
    }

    private LocalAlluxioClusterResource buildLocalAlluxioClusterResource() {
        LocalAlluxioClusterResource.Builder resource = new LocalAlluxioClusterResource.Builder();
        this.customizeClusterResource(resource);
        return resource.build();
    }

    protected void writeIncreasingBytesToFile(AlluxioURI filePath, int fileLen, CreateFilePOptions op) throws Exception {
        this.writeIncreasingBytesToFile(this.mFileSystem, filePath, fileLen, op);
    }

    protected void writeIncreasingBytesToFile(FileSystem fs, AlluxioURI filePath, int fileLen, CreateFilePOptions op) throws Exception {
        try (FileOutStream os = fs.createFile(filePath, op);){
            for (int k = 0; k < fileLen; ++k) {
                os.write((int)((byte)k));
            }
        }
    }

    protected void writeIncreasingByteArrayToFile(AlluxioURI filePath, int fileLen, CreateFilePOptions op) throws Exception {
        try (FileOutStream os = this.mFileSystem.createFile(filePath, op);){
            os.write(BufferUtils.getIncreasingByteArray((int)fileLen));
        }
    }

    protected void writeTwoIncreasingByteArraysToFile(AlluxioURI filePath, int fileLen, CreateFilePOptions op) throws Exception {
        try (FileOutStream os = this.mFileSystem.createFile(filePath, op);){
            int len1 = fileLen / 2;
            int len2 = fileLen - len1;
            os.write(BufferUtils.getIncreasingByteArray((int)0, (int)len1), 0, len1);
            os.write(BufferUtils.getIncreasingByteArray((int)len1, (int)len2), 0, len2);
        }
    }

    protected void checkFileInAlluxio(AlluxioURI filePath, int fileLen) throws Exception {
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((long)fileLen, (long)status.getLength());
        try (FileInStream is = this.mFileSystem.openFile(filePath, OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            byte[] res = new byte[(int)status.getLength()];
            Assert.assertEquals((long)((int)status.getLength()), (long)is.read(res));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)fileLen, (byte[])res));
        }
    }

    protected void checkFileInUnderStorage(AlluxioURI filePath, int fileLen) throws Exception {
        URIStatus status = this.mFileSystem.getStatus(filePath);
        String checkpointPath = status.getUfsPath();
        UnderFileSystem ufs = UnderFileSystem.Factory.create((String)checkpointPath, (AlluxioConfiguration)Configuration.global());
        try (InputStream is = ufs.open(checkpointPath);){
            int bytesRead;
            byte[] res = new byte[(int)status.getLength()];
            int totalBytesRead = 0;
            while ((bytesRead = is.read(res, totalBytesRead, res.length - totalBytesRead)) > 0) {
                totalBytesRead += bytesRead;
            }
            Assert.assertEquals((long)((int)status.getLength()), (long)totalBytesRead);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)fileLen, (byte[])res));
        }
    }
}

