/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="recycle the test cases after the BlockStore is removed")
public final class BufferedBlockInStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int MIN_LEN = 0;
    private static final int MAX_LEN = 255;
    private static final int DELTA = 33;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private static FileSystem sFileSystem;
    private static String sTestPath;

    @BeforeClass
    public static void beforeClass() throws Exception {
        sFileSystem = sLocalAlluxioClusterResource.get().getClient();
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : BufferedBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)path, (CreateFilePOptions)op, (int)k);
            }
        }
    }

    private static List<CreateFilePOptions> getOptionSet() {
        ArrayList<CreateFilePOptions> ret = new ArrayList<CreateFilePOptions>(3);
        CreateFilePOptions optionsDefault = CreateFilePOptions.getDefaultInstance();
        ret.add(optionsDefault.toBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build());
        ret.add(optionsDefault.toBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build());
        ret.add(optionsDefault.toBuilder().setWriteType(WritePType.THROUGH).setRecursive(true).build());
        return ret;
    }

    @Test
    public void readTest1() throws IOException, AlluxioException {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : BufferedBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                for (int i = 0; i < 2; ++i) {
                    FileInStream is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                    byte[] ret = new byte[k];
                    int value = is.read();
                    int cnt = 0;
                    while (value != -1) {
                        Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                        Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                        ret[cnt++] = (byte)value;
                        value = is.read();
                    }
                    Assert.assertEquals((long)cnt, (long)k);
                    Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                    is.close();
                }
            }
        }
    }

    @Test
    public void readTest2() throws IOException, AlluxioException {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : BufferedBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                byte[] ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
            }
        }
    }

    @Test
    public void readTest3() throws IOException, AlluxioException {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : BufferedBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                byte[] ret = new byte[k / 2];
                Assert.assertEquals((long)(k / 2), (long)is.read(ret, 0, k / 2));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(k / 2), (byte[])ret));
                is.close();
                is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret, 0, k));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
            }
        }
    }

    @Test
    public void skip() throws IOException, AlluxioException {
        for (int k = 33; k <= 255; k += 33) {
            for (CreateFilePOptions op : BufferedBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                Assert.assertEquals((long)(k / 2), (long)is.skip((long)(k / 2)));
                Assert.assertEquals((long)(k / 2), (long)is.read());
                is.close();
                is = sFileSystem.openFile(path, FileSystemTestUtils.toOpenFileOptions((CreateFilePOptions)op));
                int t = k / 3;
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)t, (long)is.read());
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)(2 * t + 1), (long)is.read());
                is.close();
            }
        }
    }

    static {
        sTestPath = PathUtils.uniqPath();
    }
}

