/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DoraReadIntegrationTest
extends BaseIntegrationTest {
    private static final String UFS_ROOT = AlluxioTestDirectory.createTemporaryDirectory((String)"ufs_root").getAbsolutePath();
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, UFS_ROOT).setProperty(PropertyKey.MASTER_WORKER_REGISTER_LEASE_ENABLED, false).setProperty(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, 1024).setProperty(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED, true).build();
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    private FileSystemContext mFsContext;
    private FileSystem mFileSystem;
    private String mFilePath;
    private int mFileLength;

    @Parameterized.Parameters(name="{index}_FileLength_{0}")
    public static Collection testParams() {
        return Arrays.asList({0}, {1}, {1023}, {1024}, {1025}, {65535}, {65536}, {65537});
    }

    public DoraReadIntegrationTest(int fileLength) {
        this.mFileLength = fileLength;
    }

    @Before
    public void before() throws Exception {
        this.mFsContext = FileSystemContext.create((AlluxioConfiguration)this.mClusterResource.get().getClient().getConf());
        this.mFileSystem = this.mClusterResource.get().getClient(this.mFsContext);
        this.mFilePath = UFS_ROOT + PathUtils.uniqPath();
    }

    @Test
    public void read() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)this.mFileLength);
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)this.mFileLength, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)this.mFileLength, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void positionedRead() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)this.mFileLength);
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            byte[] buffer = new byte[this.mFileLength / 4];
            int bytesRead = stream.positionedRead((long)(this.mFileLength / 10), buffer, 0, buffer.length);
            Assert.assertEquals((long)buffer.length, (long)bytesRead);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(this.mFileLength / 10), (int)buffer.length, (byte[])buffer));
        }
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)this.mFileLength, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }
}

