/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.URIStatus;
import alluxio.client.fs.io.AbstractFileOutStreamIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.WritePType;
import alluxio.master.MasterClientContext;
import alluxio.master.block.BlockMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.meta.PersistenceState;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.WorkerInfo;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.file.FileSystemMasterClient;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="fix or remove")
public final class FileOutStreamAsyncWriteIntegrationTest
extends AbstractFileOutStreamIntegrationTest {
    private static final String TINY_WORKER_MEM = "512k";
    private static final String TINY_BLOCK_SIZE = "16k";

    @Test
    public void asyncWrite() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
        CommonUtils.sleepMs((long)1L);
        this.checkPersistStateAndWaitForPersist(filePath, 2);
    }

    @Test
    public void asyncWriteWithZeroWaitTime() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        this.createTwoBytesFile(filePath, 0L);
        CommonUtils.sleepMs((long)1L);
        this.checkPersistStateAndWaitForPersist(filePath, 2);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.persist.on.rename", "true"})
    public void asyncWriteRenameWithNoAutoPersist() throws Exception {
        AlluxioURI srcPath = new AlluxioURI(PathUtils.uniqPath());
        AlluxioURI dstPath = new AlluxioURI(PathUtils.uniqPath());
        this.createTwoBytesFile(srcPath, -1L);
        CommonUtils.sleepMs((long)1L);
        URIStatus srcStatus = this.mFileSystem.getStatus(srcPath);
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)srcStatus.getPersistenceState());
        Assert.assertTrue((boolean)srcStatus.isCompleted());
        this.mFileSystem.rename(srcPath, dstPath);
        CommonUtils.sleepMs((long)1L);
        this.checkPersistStateAndWaitForPersist(dstPath, 2);
    }

    @Test
    public void asyncWritePersistWithNoAutoPersist() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        this.createTwoBytesFile(filePath, -1L);
        CommonUtils.sleepMs((long)1L);
        URIStatus srcStatus = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)srcStatus.getPersistenceState());
        Assert.assertTrue((boolean)srcStatus.isCompleted());
        this.mFileSystem.persist(filePath);
        CommonUtils.sleepMs((long)1L);
        this.checkPersistStateAndWaitForPersist(filePath, 2);
    }

    @Test
    public void asyncWriteWithPersistWaitTime() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        this.createTwoBytesFile(filePath, 2000L);
        CommonUtils.sleepMs((long)1000L);
        this.checkPersistStateAndWaitForPersist(filePath, 2);
    }

    @Test
    public void asyncWriteTemporaryPin() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (AlluxioURI)filePath, (WritePType)WritePType.ASYNC_THROUGH, (int)100);
        URIStatus status = this.mFileSystem.getStatus(filePath);
        FileSystemMasterClient fsMasterClient = new FileSystemMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        Assert.assertTrue((boolean)fsMasterClient.getPinList().contains(status.getFileId()));
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, filePath);
        Assert.assertFalse((boolean)fsMasterClient.getPinList().contains(status.getFileId()));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.persistence.initial.wait.time", "-1", "alluxio.user.file.writetype.default", "ASYNC_THROUGH", "alluxio.worker.ramdisk.size", "512k", "alluxio.user.block.size.bytes.default", "16k", "alluxio.user.file.buffer.bytes", "16k", "alluxio.worker.tieredstore.level0.watermark.high.ratio", "0.5", "alluxio.worker.tieredstore.level0.watermark.low.ratio", "0.25"})
    public void asyncWriteNoEvictBeforeBlockCommit() throws Exception {
        long writeSize = FormatUtils.parseSpaceSize((String)TINY_WORKER_MEM) - FormatUtils.parseSpaceSize((String)TINY_BLOCK_SIZE);
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient();
        AlluxioURI p1 = new AlluxioURI("/p1");
        FileOutStream fos = fs.createFile(p1, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setPersistenceWaitTime(-1L).build());
        byte[] arr = new byte[(int)writeSize];
        Arrays.fill(arr, (byte)122);
        fos.write(arr);
        Assert.assertEquals((long)(writeSize + FormatUtils.parseSpaceSize((String)TINY_BLOCK_SIZE)), (long)this.getClusterCapacity());
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/byte-file1", (WritePType)WritePType.MUST_CACHE, (int)((int)FormatUtils.parseSpaceSize((String)TINY_BLOCK_SIZE)));
        try {
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/byte-file2", (WritePType)WritePType.MUST_CACHE, (int)(2 * (int)FormatUtils.parseSpaceSize((String)TINY_BLOCK_SIZE)));
            Assert.fail((String)"Should have failed due to non-evictable block.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        fos.close();
        FileSystemUtils.persistAndWait((FileSystem)fs, (AlluxioURI)p1, (long)0L);
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/byte-file3", (WritePType)WritePType.MUST_CACHE, (int)(2 * (int)FormatUtils.parseSpaceSize((String)TINY_BLOCK_SIZE)));
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.writetype.default", "ASYNC_THROUGH", "alluxio.user.file.persistence.initial.wait.time", "1min", "alluxio.worker.ramdisk.size", "512k", "alluxio.user.block.size.bytes.default", "16k", "alluxio.user.file.buffer.bytes", "8k"})
    public void asyncWriteNoEvict() throws Exception {
        this.testLostAsyncBlocks();
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.user.file.persistence.initial.wait.time", "-1", "alluxio.user.file.writetype.default", "ASYNC_THROUGH", "alluxio.worker.ramdisk.size", "512k", "alluxio.user.block.size.bytes.default", "16k", "alluxio.user.file.buffer.bytes", "8k"})
    public void asyncPersistNoAutoPersistNoEvict() throws Exception {
        this.testLostAsyncBlocks();
    }

    private void testLostAsyncBlocks() throws Exception {
        long cap = FormatUtils.parseSpaceSize((String)TINY_WORKER_MEM);
        FileSystem fs = this.mLocalAlluxioClusterResource.get().getClient();
        String p1 = "/test";
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)p1, (WritePType)WritePType.ASYNC_THROUGH, (int)((int)cap));
        URIStatus fstat = (URIStatus)fs.listStatus(new AlluxioURI(p1)).get(0);
        int lostBlocks = fstat.getFileBlockInfos().stream().map(FileBlockInfo::getBlockInfo).filter(blk -> blk.getLocations().size() <= 0).mapToInt(blk -> 1).sum();
        Assert.assertEquals((long)cap, (long)this.getClusterCapacity());
        Assert.assertEquals((long)cap, (long)this.getUsedWorkerSpace());
        Assert.assertEquals((long)100L, (long)fstat.getInAlluxioPercentage());
        Assert.assertEquals((long)0L, (long)lostBlocks);
        try {
            FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/byte-file1", (WritePType)WritePType.MUST_CACHE, (int)1);
            Assert.assertTrue((String)"Shouldn't reach here.", (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileSystemUtils.persistAndWait((FileSystem)fs, (AlluxioURI)new AlluxioURI(p1), (long)0L);
        fstat = (URIStatus)fs.listStatus(new AlluxioURI(p1)).get(0);
        Assert.assertTrue((boolean)fstat.isPersisted());
        Assert.assertEquals((long)0L, (long)((FileSystemMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(FileSystemMaster.class)).getPinIdList().size());
        FileSystemTestUtils.createByteFile((FileSystem)fs, (String)"/byte-file2", (WritePType)WritePType.MUST_CACHE, (int)1);
    }

    @Test
    public void asyncWriteEmptyFile() throws Exception {
        AlluxioURI filePath = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setRecursive(true).build()).close();
        this.checkPersistStateAndWaitForPersist(filePath, 0);
    }

    private long getClusterCapacity() throws UnavailableException {
        return ((BlockMaster)this.mLocalAlluxioClusterResource.get().getLocalAlluxioMaster().getMasterProcess().getMaster(BlockMaster.class)).getWorkerInfoList().stream().map(WorkerInfo::getCapacityBytes).mapToLong(Long::new).sum();
    }

    private long getUsedWorkerSpace() {
        BlockWorker blkWorker = (BlockWorker)this.mLocalAlluxioClusterResource.get().getWorkerProcess().getWorker(BlockWorker.class);
        return ((BlockWorker)this.mLocalAlluxioClusterResource.get().getWorkerProcess().getWorker(BlockWorker.class)).getStoreMeta().getUsedBytes();
    }

    private void createTwoBytesFile(AlluxioURI path, long persistenceWaitTime) throws Exception {
        FileOutStream os = this.mFileSystem.createFile(path, CreateFilePOptions.newBuilder().setWriteType(WritePType.ASYNC_THROUGH).setPersistenceWaitTime(persistenceWaitTime).setRecursive(true).build());
        os.write(0);
        os.write(1);
        os.close();
    }

    private void checkPersistStateAndWaitForPersist(AlluxioURI path, int length) throws Exception {
        URIStatus status = this.mFileSystem.getStatus(path);
        Assert.assertEquals((Object)PersistenceState.TO_BE_PERSISTED.toString(), (Object)status.getPersistenceState());
        Assert.assertTrue((boolean)status.isCompleted());
        IntegrationTestUtils.waitForPersist(this.mLocalAlluxioClusterResource, path);
        status = this.mFileSystem.getStatus(path);
        Assert.assertEquals((Object)PersistenceState.PERSISTED.toString(), (Object)status.getPersistenceState());
        this.checkFileInAlluxio(path, length);
        this.checkFileInUnderStorage(path, length);
    }
}

