/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.exception.PreconditionMessage;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="bowen", comment="recycle the test cases after the BlockStore is removed")
public final class LocalBlockInStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int MIN_LEN = 0;
    private static final int MAX_LEN = 255;
    private static final int DELTA = 33;
    @ClassRule
    public static LocalAlluxioClusterResource sLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().build();
    private static FileSystem sFileSystem = null;
    private static CreateFilePOptions sWriteBoth;
    private static CreateFilePOptions sWriteAlluxio;
    private static OpenFilePOptions sReadNoCache;
    private static OpenFilePOptions sReadCachePromote;
    private static String sTestPath;
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @BeforeClass
    public static final void beforeClass() throws Exception {
        sFileSystem = sLocalAlluxioClusterResource.get().getClient();
        sWriteBoth = CreateFilePOptions.newBuilder().setWriteType(WritePType.CACHE_THROUGH).setRecursive(true).build();
        sWriteAlluxio = CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build();
        sReadCachePromote = OpenFilePOptions.newBuilder().setReadType(ReadPType.CACHE_PROMOTE).build();
        sReadNoCache = OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build();
        sTestPath = PathUtils.uniqPath();
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI path = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileSystemTestUtils.createByteFile((FileSystem)sFileSystem, (AlluxioURI)path, (CreateFilePOptions)op, (int)k);
            }
        }
    }

    private static List<CreateFilePOptions> getOptionSet() {
        ArrayList<CreateFilePOptions> ret = new ArrayList<CreateFilePOptions>(2);
        ret.add(sWriteBoth);
        ret.add(sWriteAlluxio);
        return ret;
    }

    @Test
    public void readTest1() throws Exception {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                byte[] ret = new byte[k];
                int value = is.read();
                int cnt = 0;
                while (value != -1) {
                    Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                    ret[cnt++] = (byte)value;
                    value = is.read();
                }
                Assert.assertEquals((long)cnt, (long)k);
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                is = sFileSystem.openFile(uri, sReadCachePromote);
                ret = new byte[k];
                value = is.read();
                cnt = 0;
                while (value != -1) {
                    Assert.assertTrue((value >= 0 ? 1 : 0) != 0);
                    Assert.assertTrue((value < 256 ? 1 : 0) != 0);
                    ret[cnt++] = (byte)value;
                    value = is.read();
                }
                Assert.assertEquals((long)cnt, (long)k);
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                Assert.assertTrue((sFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void readTest2() throws Exception {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                byte[] ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                is = sFileSystem.openFile(uri, sReadCachePromote);
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                Assert.assertTrue((sFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void readTest3() throws Exception {
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                byte[] ret = new byte[k / 2];
                Assert.assertEquals((long)(k / 2), (long)is.read(ret, 0, k / 2));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(k / 2), (byte[])ret));
                is.close();
                is = sFileSystem.openFile(uri, sReadCachePromote);
                ret = new byte[k];
                Assert.assertEquals((long)k, (long)is.read(ret, 0, k));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)k, (byte[])ret));
                is.close();
                Assert.assertTrue((sFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void seekExceptionTest1() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_NEGATIVE.toString(), -1));
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                Throwable throwable = null;
                try {
                    is.seek(-1L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Test
    public void seekExceptionTest2() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(String.format(PreconditionMessage.ERR_SEEK_PAST_END_OF_FILE.toString(), 1));
        for (int k = 0; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                Throwable throwable = null;
                try {
                    is.seek((long)(k + 1));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Test
    public void seek() throws Exception {
        for (int k = 33; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                is.seek((long)(k / 3));
                Assert.assertEquals((long)(k / 3), (long)is.read());
                is.seek((long)(k / 2));
                Assert.assertEquals((long)(k / 2), (long)is.read());
                is.seek((long)(k / 4));
                Assert.assertEquals((long)(k / 4), (long)is.read());
                is.close();
            }
        }
    }

    @Test
    public void skip() throws Exception {
        for (int k = 33; k <= 255; k += 33) {
            for (CreateFilePOptions op : LocalBlockInStreamIntegrationTest.getOptionSet()) {
                AlluxioURI uri = new AlluxioURI(sTestPath + "/file_" + k + "_" + op.hashCode());
                FileInStream is = sFileSystem.openFile(uri, sReadNoCache);
                Assert.assertEquals((long)(k / 2), (long)is.skip((long)(k / 2)));
                Assert.assertEquals((long)(k / 2), (long)is.read());
                is.close();
                is = sFileSystem.openFile(uri, sReadCachePromote);
                int t = k / 3;
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)t, (long)is.read());
                Assert.assertEquals((long)t, (long)is.skip((long)t));
                Assert.assertEquals((long)(2 * t + 1), (long)is.read());
                is.close();
                Assert.assertTrue((sFileSystem.getStatus(uri).getInAlluxioPercentage() == 100 ? 1 : 0) != 0);
            }
        }
    }
}

