/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fs.io;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class LocalCacheFileInStreamIntegrationTest
extends BaseIntegrationTest {
    private static final int PAGE_SIZE_BYTES = 1024;
    private static final int PAGE_COUNT = 32;
    private static final int CACHE_SIZE_BYTES = 32768;
    @Rule
    public LocalAlluxioClusterResource mClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE, 1024).setProperty(PropertyKey.USER_CLIENT_CACHE_SIZE, String.valueOf(32768)).setProperty(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, 0x100000).setProperty(PropertyKey.USER_CLIENT_CACHE_ENABLED, true).setProperty(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED, false).setProperty(PropertyKey.USER_CLIENT_CACHE_STORE_OVERHEAD, 0).build();
    @Rule
    public final ExpectedException mThrown = ExpectedException.none();
    private FileSystemContext mFsContext;
    private FileSystem mFileSystem;
    private String mFilePath;

    @Before
    public void before() throws Exception {
        this.mFsContext = FileSystemContext.create((AlluxioConfiguration)this.mClusterResource.get().getClient().getConf());
        this.mFileSystem = this.mClusterResource.get().getClient(this.mFsContext);
        this.mFilePath = PathUtils.uniqPath();
    }

    @After
    public void after() throws Exception {
        this.mFsContext.close();
    }

    @Test
    public void read() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)1024);
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)1024, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        this.mClusterResource.get().stopWorkers();
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)1024, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void positionedRead() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)1024);
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            byte[] buffer = new byte[256];
            int bytesRead = stream.positionedRead(102L, buffer, 0, buffer.length);
            Assert.assertEquals((long)buffer.length, (long)bytesRead);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)102, (int)buffer.length, (byte[])buffer));
        }
        this.mClusterResource.get().stopWorkers();
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)1024, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    public void multiPageRead() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        int pageCount = 8;
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)(pageCount * 1024));
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            byte[] buffer = new byte[256];
            for (int i = 0; i < pageCount; i += 2) {
                int bytesRead = stream.positionedRead((long)(i * 1024), buffer, 0, buffer.length);
                Assert.assertEquals((long)buffer.length, (long)bytesRead);
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(i * 1024), (int)buffer.length, (byte[])buffer));
            }
        }
        stream = this.mFileSystem.openFile(path);
        var4_4 = null;
        try {
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)(pageCount * 1024), (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_4 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="jiaming", comment="fix this test")
    public void cacheAndEvict() throws Exception {
        AlluxioURI path = new AlluxioURI(this.mFilePath);
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)this.mFilePath, (WritePType)WritePType.CACHE_THROUGH, (int)65536);
        try (FileInStream stream = this.mFileSystem.openFile(path);){
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)65536, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        this.mClusterResource.get().stopWorkers();
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            stream.seek(32768L);
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)32768, (int)32768, (byte[])ByteStreams.toByteArray((InputStream)stream)));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        stream = this.mFileSystem.openFile(path);
        var3_3 = null;
        try {
            this.mThrown.expect(UnavailableException.class);
            ByteStreams.toByteArray((InputStream)stream);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var3_3 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }
}

