/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.master.LocalAlluxioCluster;
import alluxio.testutils.IntegrationTestUtils;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.CommonUtils;
import alluxio.util.OSUtils;
import alluxio.util.ShellUtils;
import alluxio.util.WaitForOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

@DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="LuQQiu", comment="fix tests")
public abstract class AbstractFuseIntegrationTest {
    protected static final String ALLUXIO_ROOT = "/";
    private static final int BLOCK_SIZE = 4096;
    private static final int WAIT_TIMEOUT_MS = 60000;
    private final LocalAlluxioCluster mAlluxioCluster = new LocalAlluxioCluster();
    private FileSystem mFileSystem;
    private FileSystemContext mFileSystemContext;
    protected String mMountPoint;
    @Rule
    public TestName mTestName = new TestName();

    public abstract void configure();

    public abstract void mountFuse(FileSystemContext var1, FileSystem var2, String var3, String var4);

    public abstract void beforeStop() throws Exception;

    public abstract void afterStop() throws Exception;

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeTrue((String)"This test only runs when libfuse is installed", (boolean)AlluxioFuseUtils.isFuseInstalled());
    }

    @Before
    public void before() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.USER_METADATA_CACHE_MAX_SIZE, (Object)0);
        String clusterName = IntegrationTestUtils.getTestName(this.getClass().getSimpleName(), this.mTestName.getMethodName());
        this.mMountPoint = AlluxioTestDirectory.createTemporaryDirectory((String)clusterName).getAbsolutePath();
        this.mAlluxioCluster.initConfiguration(ALLUXIO_ROOT);
        Configuration.set((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, (Object)4096);
        this.configure();
        IntegrationTestUtils.reserveMasterPorts();
        Configuration.global().validate();
        this.mAlluxioCluster.start();
        this.mFileSystemContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        this.mFileSystem = this.mAlluxioCluster.getClient(this.mFileSystemContext);
        this.mountFuse(this.mFileSystemContext, this.mFileSystem, this.mMountPoint, ALLUXIO_ROOT);
        if (!this.waitForFuseMounted()) {
            this.stop();
            Assert.fail((String)"Could not setup FUSE mount point");
        }
    }

    @After
    public void after() throws Exception {
        this.beforeStop();
        this.stop();
        this.afterStop();
    }

    protected void umountFromShellIfMounted() throws IOException {
        if (this.fuseMounted()) {
            ShellUtils.execCommand((String[])new String[]{"umount", this.mMountPoint});
        }
    }

    private void stop() throws Exception {
        try {
            this.mAlluxioCluster.stop();
        }
        finally {
            IntegrationTestUtils.releaseMasterPorts();
        }
        if (this.fuseMounted()) {
            ShellUtils.execCommand((String[])new String[]{"umount", this.mMountPoint});
        }
    }

    @Test
    @Ignore
    public void cat() throws Exception {
        String testFile = "/catTestFile";
        String content = "Alluxio Cat Test File Content";
        try (FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(testFile));){
            os.write(content.getBytes());
        }
        String result = ShellUtils.execCommand((String[])new String[]{"cat", this.mMountPoint + testFile});
        Assert.assertEquals((Object)(content + "\n"), (Object)result);
    }

    @Test
    @Ignore
    public void chgrp() throws Exception {
        String testFile = "/chgrpTestFile";
        String userName = System.getProperty("user.name");
        Optional groupName = AlluxioFuseUtils.getGroupName((String)userName);
        Assert.assertTrue((boolean)groupName.isPresent());
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)testFile, (WritePType)WritePType.MUST_CACHE, (int)10);
        ShellUtils.execCommand((String[])new String[]{"chgrp", (String)groupName.get(), this.mMountPoint + testFile});
        Assert.assertEquals(groupName.get(), (Object)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getGroup());
    }

    @Test
    @Ignore
    public void chmod() throws Exception {
        String testFile = "/chmodTestFile";
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)testFile, (WritePType)WritePType.MUST_CACHE, (int)10);
        ShellUtils.execCommand((String[])new String[]{"chmod", "777", this.mMountPoint + testFile});
        Assert.assertEquals((long)511L, (long)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getMode());
    }

    @Test
    @Ignore
    public void chown() throws Exception {
        String testFile = "/chownTestFile";
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)testFile, (WritePType)WritePType.MUST_CACHE, (int)10);
        String userName = System.getProperty("user.name");
        Optional groupName = AlluxioFuseUtils.getGroupName((String)userName);
        Assert.assertTrue((boolean)groupName.isPresent());
        ShellUtils.execCommand((String[])new String[]{"chown", userName + ":" + (String)groupName.get(), this.mMountPoint + testFile});
        Assert.assertEquals((Object)userName, (Object)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getOwner());
        Assert.assertEquals(groupName.get(), (Object)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getGroup());
    }

    @Test
    @Ignore
    public void cp() throws Exception {
        String testFile = "/cpTestFile";
        String content = "Alluxio Cp Test File Content";
        File localFile = this.generateFileContent("/TestFileOnLocalPath", content.getBytes());
        ShellUtils.execCommand((String[])new String[]{"cp", localFile.getPath(), this.mMountPoint + testFile});
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(testFile)));
        String testFolder = "/cpTestFolder";
        ShellUtils.execCommand((String[])new String[]{"mkdir", this.mMountPoint + testFolder});
        ShellUtils.execCommand((String[])new String[]{"cp", this.mMountPoint + testFile, this.mMountPoint + testFolder + testFile});
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(testFolder + testFile)));
        byte[] read = new byte[content.length()];
        try (FileInStream is = this.mFileSystem.openFile(new AlluxioURI(testFile), OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            is.read(read);
        }
        Assert.assertEquals((Object)content, (Object)new String(read, StandardCharsets.UTF_8));
    }

    @Test
    @Ignore
    public void ddDuAndRm() throws Exception {
        String testFile = "/ddTestFile";
        this.createFileInFuse(testFile);
        ShellUtils.execCommand((String[])new String[]{"head", "-c", "10", this.mMountPoint + testFile});
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(testFile)));
        Assert.assertEquals((long)40960L, (long)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getLength());
        String output = ShellUtils.execCommand((String[])new String[]{"du", "-k", this.mMountPoint + testFile});
        Assert.assertEquals((Object)"40", (Object)output.split("\\s+")[0]);
        ShellUtils.execCommand((String[])new String[]{"rm", this.mMountPoint + testFile});
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(testFile)));
    }

    @Test
    @Ignore
    public void head() throws Exception {
        String testFile = "/headTestFile";
        String content = "Alluxio Head Test File Content";
        try (FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(testFile));){
            os.write(content.getBytes());
        }
        String result = ShellUtils.execCommand((String[])new String[]{"head", "-c", "17", this.mMountPoint + testFile});
        Assert.assertEquals((Object)"Alluxio Head Test\n", (Object)result);
    }

    @Test
    @Ignore
    public void ls() throws Exception {
        Assume.assumeTrue((boolean)OSUtils.isLinux());
        String testFile = "/lsTestFile";
        this.createFileInFuse(testFile);
        String out = ShellUtils.execCommand((String[])new String[]{"ls", "-sh", this.mMountPoint + testFile});
        Assert.assertFalse((boolean)out.isEmpty());
        Assert.assertEquals((Object)"40K", (Object)out.split("\\s+")[0]);
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(testFile)));
        Assert.assertEquals((long)40960L, (long)this.mFileSystem.getStatus(new AlluxioURI(testFile)).getLength());
    }

    @Test
    @Ignore
    public void mkdirAndMv() throws Exception {
        String testFile = "/mvTestFile";
        String testFolder = "/mkdirTestFolder";
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)testFile, (WritePType)WritePType.MUST_CACHE, (int)10);
        ShellUtils.execCommand((String[])new String[]{"mkdir", this.mMountPoint + testFolder});
        ShellUtils.execCommand((String[])new String[]{"mv", this.mMountPoint + testFile, this.mMountPoint + testFolder + testFile});
        Assert.assertFalse((boolean)this.mFileSystem.exists(new AlluxioURI(testFile)));
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(testFolder + testFile)));
    }

    @Test
    @Ignore
    public void tail() throws Exception {
        String testFile = "/tailTestFile";
        String content = "Alluxio Tail Test File Content";
        try (FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(testFile));){
            os.write(content.getBytes());
        }
        String result = ShellUtils.execCommand((String[])new String[]{"tail", "-c", "17", this.mMountPoint + testFile});
        Assert.assertEquals((Object)"Test File Content\n", (Object)result);
    }

    @Test
    @LocalAlluxioClusterResource.Config(confParams={"alluxio.security.stale.channel.purge.interval", "250ms"})
    @Ignore
    public void continueWithRevokedAuth() throws Exception {
        String testFile = "/tailTestFile";
        String content = "Alluxio Tail Test File Content";
        try (FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(testFile));){
            os.write(content.getBytes());
        }
        String result = ShellUtils.execCommand((String[])new String[]{"tail", "-c", "17", this.mMountPoint + testFile});
        Assert.assertEquals((Object)"Test File Content\n", (Object)result);
        Thread.sleep(500L);
        result = ShellUtils.execCommand((String[])new String[]{"tail", "-c", "17", this.mMountPoint + testFile});
        Assert.assertEquals((Object)"Test File Content\n", (Object)result);
    }

    @Test
    @Ignore
    public void touchAndLs() throws Exception {
        FileSystemTestUtils.createByteFile((FileSystem)this.mFileSystem, (String)"/lsTestFile", (WritePType)WritePType.MUST_CACHE, (int)10);
        String touchTestFile = "/touchTestFile";
        ShellUtils.execCommand((String[])new String[]{"touch", this.mMountPoint + touchTestFile});
        String lsResult = ShellUtils.execCommand((String[])new String[]{"ls", this.mMountPoint});
        Assert.assertTrue((boolean)lsResult.contains("lsTestFile"));
        Assert.assertTrue((boolean)lsResult.contains("touchTestFile"));
        Assert.assertTrue((boolean)this.mFileSystem.exists(new AlluxioURI(touchTestFile)));
    }

    private void createFileInFuse(String filename) {
        try {
            ShellUtils.execCommand((String[])new String[]{"dd", "if=/dev/zero", "of=" + this.mMountPoint + filename, "count=10", "bs=4096"});
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    private File generateFileContent(String path, byte[] toWrite) throws IOException {
        File testFile = new File(this.mAlluxioCluster.getAlluxioHome() + path);
        testFile.createNewFile();
        try (FileOutputStream fos = new FileOutputStream(testFile);){
            fos.write(toWrite);
        }
        return testFile;
    }

    private boolean fuseMounted() throws IOException {
        String result = ShellUtils.execCommand((String[])new String[]{"mount"});
        return result.contains(this.mMountPoint);
    }

    boolean waitForFuseMounted() {
        if (OSUtils.isLinux() || OSUtils.isMacOS()) {
            try {
                CommonUtils.waitFor((String)"Alluxio-Fuse mounted on local filesystem", () -> {
                    try {
                        return this.fuseMounted();
                    }
                    catch (IOException e) {
                        return false;
                    }
                }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(60000L));
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (TimeoutException te) {
                return false;
            }
        }
        return false;
    }
}

