/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse;

import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.fuse.AbstractFuseIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.options.FuseOptions;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.struct.FuseFileInfo;
import alluxio.jnifuse.utils.LibfuseVersion;
import alluxio.util.io.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Test;

public class JNIFuseIntegrationTest
extends AbstractFuseIntegrationTest {
    private static final int FILE_LEN = 128;
    private AlluxioJniFuseFileSystem mFuseFileSystem;

    @Override
    public void configure() {
        Configuration.set((PropertyKey)PropertyKey.FUSE_JNIFUSE_ENABLED, (Object)true);
    }

    @Override
    public void mountFuse(FileSystemContext context, FileSystem fileSystem, String mountPoint, String alluxioRoot) {
        Configuration.set((PropertyKey)PropertyKey.FUSE_MOUNT_ALLUXIO_PATH, (Object)alluxioRoot);
        Configuration.set((PropertyKey)PropertyKey.FUSE_MOUNT_POINT, (Object)mountPoint);
        AlluxioConfiguration conf = Configuration.global();
        LibFuse.loadLibrary((LibfuseVersion)AlluxioFuseUtils.getLibfuseVersion((AlluxioConfiguration)conf));
        this.mFuseFileSystem = new AlluxioJniFuseFileSystem(context, fileSystem, FuseOptions.create((AlluxioConfiguration)conf));
        this.mFuseFileSystem.mount(false, false, new HashSet());
    }

    @Override
    public void beforeStop() throws IOException {
        try {
            this.mFuseFileSystem.umount(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.umountFromShellIfMounted();
    }

    @Override
    public void afterStop() {
    }

    @Test
    public void createWriteOpenRead() throws Exception {
        String testFile = "/createWriteOpenReadTestFile";
        try (AlluxioFuseUtils.CloseableFuseFileInfo info = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo fuseFileInfo = info.get();
            fuseFileInfo.flags.set(OpenFlags.O_RDONLY.intValue());
            Assert.assertNotEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, fuseFileInfo));
            this.createTestFile(testFile, fuseFileInfo, 128);
            this.readAndValidateTestFile(testFile, fuseFileInfo, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openWriteNonExisting() throws Exception {
        String testFile = "/openWriteNonExisting";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            info.flags.set(OpenFlags.O_WRONLY.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
            try {
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
            this.readAndValidateTestFile(testFile, info, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openWriteExistingWithoutTruncFlag() throws Exception {
        String testFile = "/openWriteExistingWithoutTruncFlag";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            this.createTestFile(testFile, info, 128);
            info.flags.set(OpenFlags.O_WRONLY.intValue());
            try {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertTrue((this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info) < 0 ? 1 : 0) != 0);
            }
            finally {
                this.mFuseFileSystem.release(testFile, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openWriteExistingWithTruncFlag() throws Exception {
        String testFile = "/openWriteExistingWithTruncFlag";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            this.createTestFile(testFile, info, 64);
            info.flags.set(OpenFlags.O_WRONLY.intValue() | OpenFlags.O_TRUNC.intValue());
            try {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
            }
            finally {
                this.mFuseFileSystem.release(testFile, info);
            }
            this.readAndValidateTestFile(testFile, info, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openWriteExistingWithTruncate() throws Exception {
        String testFile = "/openWriteExistingWithTruncate";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            ByteBuffer buffer;
            FuseFileInfo info = closeableFuseFileInfo.get();
            this.createTestFile(testFile, info, 64);
            info.flags.set(OpenFlags.O_WRONLY.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.truncate(testFile, 64L));
                Assert.assertNotEquals((long)0L, (long)this.mFuseFileSystem.truncate(testFile, 128L));
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.truncate(testFile, 0L));
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.truncate(testFile, 256L));
                buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
            }
            finally {
                this.mFuseFileSystem.release(testFile, info);
            }
            info.flags.set(OpenFlags.O_RDONLY.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                buffer = ByteBuffer.wrap(new byte[128]);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.read(testFile, buffer, 128L, 0L, info));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)128, (byte[])buffer.array()));
                buffer = ByteBuffer.wrap(new byte[128]);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.read(testFile, buffer, 128L, 128L, info));
                for (byte cur : buffer.array()) {
                    Assert.assertEquals((long)0L, (long)cur);
                }
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openReadWriteNonExisting() throws Exception {
        String testFile = "/openReadWriteNonExistingFile";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            info.flags.set(OpenFlags.O_RDWR.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
                buffer.clear();
                Assert.assertTrue((this.mFuseFileSystem.read(testFile, buffer, 128L, 0L, info) < 0 ? 1 : 0) != 0);
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
            this.readAndValidateTestFile(testFile, info, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openReadWriteExisting() throws Exception {
        String testFile = "/openReadWriteExisting";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            this.createTestFile(testFile, info, 128);
            info.flags.set(OpenFlags.O_RDWR.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                ByteBuffer buffer = ByteBuffer.wrap(new byte[128]);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.read(testFile, buffer, 128L, 0L, info));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)128, (byte[])buffer.array()));
                Assert.assertTrue((this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info) < 0 ? 1 : 0) != 0);
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openReadWriteEmptyFile() throws Exception {
        String testFile = "/openReadWriteEmptyFile";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            info.flags.set(OpenFlags.O_WRONLY.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.create(testFile, 100644L, info));
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            info.flags.set(OpenFlags.O_RDWR.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
                buffer.clear();
                Assert.assertTrue((this.mFuseFileSystem.read(testFile, buffer, 128L, 0L, info) < 0 ? 1 : 0) != 0);
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
            this.readAndValidateTestFile(testFile, info, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void openReadWriteTruncExisting() throws Exception {
        String testFile = "/openReadWriteTruncExisting";
        try (AlluxioFuseUtils.CloseableFuseFileInfo closeableFuseFileInfo = new AlluxioFuseUtils.CloseableFuseFileInfo();){
            FuseFileInfo info = closeableFuseFileInfo.get();
            this.createTestFile(testFile, info, 64);
            info.flags.set(OpenFlags.O_RDWR.intValue() | OpenFlags.O_TRUNC.intValue());
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
            try {
                ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)128);
                Assert.assertEquals((long)128L, (long)this.mFuseFileSystem.write(testFile, buffer, 128L, 0L, info));
                buffer.clear();
                Assert.assertTrue((this.mFuseFileSystem.read(testFile, buffer, 128L, 0L, info) < 0 ? 1 : 0) != 0);
            }
            finally {
                Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
            }
            this.readAndValidateTestFile(testFile, info, 128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestFile(String testFile, FuseFileInfo info, int fileLen) {
        info.flags.set(OpenFlags.O_WRONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.create(testFile, 100644L, info));
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)fileLen);
        try {
            Assert.assertEquals((long)fileLen, (long)this.mFuseFileSystem.write(testFile, buffer, (long)fileLen, 0L, info));
        }
        finally {
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndValidateTestFile(String testFile, FuseFileInfo info, int fileLen) {
        info.flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.open(testFile, info));
        try {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[fileLen]);
            Assert.assertEquals((long)fileLen, (long)this.mFuseFileSystem.read(testFile, buffer, (long)fileLen, 0L, info));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)fileLen, (byte[])buffer.array()));
        }
        finally {
            Assert.assertEquals((long)0L, (long)this.mFuseFileSystem.release(testFile, info));
        }
    }
}

