/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora;

import alluxio.AlluxioTestDirectory;
import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.FileSystemOptions;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.client.file.ufs.UfsBaseFileSystem;
import alluxio.client.fuse.dora.FuseUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.options.FuseOptions;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.utils.LibfuseVersion;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.underfs.local.LocalUnderFileSystemFactory;
import alluxio.underfs.s3a.S3AUnderFileSystemFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Failed to unmount because of Permission Denied")
public class FuseEndToEndTest {
    private static final String TEST_S3A_PATH_CONF = "alluxio.test.s3a.path";
    private static final String MOUNT_POINT = AlluxioTestDirectory.createTemporaryDirectory((String)"ufs").toString();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String ufs;
        String s3Path = System.getProperty(TEST_S3A_PATH_CONF);
        if (s3Path != null) {
            ufs = new AlluxioURI(s3Path).join(UUID.randomUUID().toString()).toString();
            UnderFileSystemFactoryRegistry.register((UnderFileSystemFactory)new S3AUnderFileSystemFactory());
        } else {
            ufs = AlluxioTestDirectory.createTemporaryDirectory((String)"ufs").toString();
            UnderFileSystemFactoryRegistry.register((UnderFileSystemFactory)new LocalUnderFileSystemFactory());
        }
        InstancedConfiguration conf = Configuration.copyGlobal();
        conf.set(PropertyKey.FUSE_MOUNT_POINT, (Object)MOUNT_POINT, Source.RUNTIME);
        FileSystemContext context = FileSystemContext.create((ClientContext)ClientContext.create((AlluxioConfiguration)conf));
        LibFuse.loadLibrary((LibfuseVersion)AlluxioFuseUtils.getLibfuseVersion((AlluxioConfiguration)Configuration.global()));
        UfsFileSystemOptions ufsOptions = new UfsFileSystemOptions(ufs);
        UfsBaseFileSystem fileSystem = new UfsBaseFileSystem(context, ufsOptions);
        FileSystemOptions fileSystemOptions = FileSystemOptions.Builder.fromConf((AlluxioConfiguration)context.getClusterConf()).setUfsFileSystemOptions(ufsOptions).build();
        AlluxioJniFuseFileSystem fuseFileSystem = new AlluxioJniFuseFileSystem(context, (FileSystem)fileSystem, FuseOptions.create((AlluxioConfiguration)Configuration.global(), (FileSystemOptions)fileSystemOptions, (boolean)false));
        fuseFileSystem.mount(false, false, new HashSet());
        if (!FuseUtils.waitForFuseMounted(MOUNT_POINT)) {
            FuseUtils.umountFromShellIfMounted(MOUNT_POINT);
            Assert.fail((String)"Could not setup FUSE mount point");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        FuseUtils.umountFromShellIfMounted(MOUNT_POINT);
    }

    @Test
    public void createDeleteEmptyFile() throws Exception {
        String testFile = Paths.get(MOUNT_POINT, "/createDeleteEmptyFile").toString();
        File file = new File(testFile);
        Assert.assertFalse((boolean)file.exists());
        new FileOutputStream(testFile).close();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertEquals((long)0L, (long)file.length());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void createDeleteDirectory() {
        String testDir = Paths.get(MOUNT_POINT, "/createDeleteDirectory").toString();
        File dir = new File(testDir);
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.mkdir());
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        Assert.assertTrue((boolean)dir.delete());
        Assert.assertFalse((boolean)dir.exists());
    }

    @Test
    public void writeThenRead() throws Exception {
        String testFile = Paths.get(MOUNT_POINT, "/writeThenRead").toString();
        byte[] content = "Alluxio Fuse Test File Content".getBytes();
        File file = new File(testFile);
        Assert.assertFalse((boolean)file.exists());
        try (FileOutputStream outputStream = new FileOutputStream(testFile);){
            outputStream.write(content);
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)content.length, (long)file.length());
        var5_5 = null;
        try (FileInputStream inputStream = new FileInputStream(testFile);){
            byte[] res = new byte[content.length];
            Assert.assertEquals((long)content.length, (long)inputStream.read(res));
            Assert.assertEquals((Object)Arrays.toString(content), (Object)Arrays.toString(res));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void listDirectory() throws Exception {
        String testDir = Paths.get(MOUNT_POINT, "/listDirectory").toString();
        File dir = new File(testDir);
        Assert.assertFalse((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.mkdir());
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        String testFile1 = Paths.get(testDir, "/file1").toString();
        String testFile2 = Paths.get(testDir, "/file2").toString();
        new FileOutputStream(testFile1).close();
        new FileOutputStream(testFile2).close();
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        Assert.assertEquals((long)2L, (long)files.length);
    }

    @Test
    @Ignore(value="Throwing core dump, need to debug")
    public void rename() throws Exception {
        String srcFile = Paths.get(MOUNT_POINT, "/renameSrc").toString();
        String dstFile = Paths.get(MOUNT_POINT, "/renameDst").toString();
        File file = new File(srcFile);
        new FileOutputStream(srcFile).close();
        Assert.assertTrue((boolean)file.renameTo(new File(dstFile)));
    }
}

