/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora;

import alluxio.util.CommonUtils;
import alluxio.util.OSUtils;
import alluxio.util.ShellUtils;
import alluxio.util.WaitForOptions;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class FuseUtils {
    private static final int WAIT_TIMEOUT_MS = 60000;

    public static void umountFromShellIfMounted(String mountPoint) throws IOException {
        if (FuseUtils.fuseMounted(mountPoint)) {
            ShellUtils.execCommand((String[])new String[]{"umount", mountPoint});
        }
    }

    public static boolean fuseMounted(String mountPoint) throws IOException {
        String result = ShellUtils.execCommand((String[])new String[]{"mount"});
        return result.contains(mountPoint);
    }

    public static boolean waitForFuseMounted(String mountPoint) {
        if (OSUtils.isLinux() || OSUtils.isMacOS()) {
            try {
                CommonUtils.waitFor((String)"Alluxio-Fuse mounted on local filesystem", () -> {
                    try {
                        return FuseUtils.fuseMounted(mountPoint);
                    }
                    catch (IOException e) {
                        return false;
                    }
                }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(60000L));
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (TimeoutException te) {
                return false;
            }
        }
        return false;
    }
}

