/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.hdfs3;

import alluxio.AlluxioTestDirectory;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.options.FileSystemOptions;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.client.fuse.dora.FuseUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.fuse.AlluxioJniFuseFileSystem;
import alluxio.fuse.options.FuseOptions;
import alluxio.testutils.LocalAlluxioClusterResource;
import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class AbstractFuseHdfsIntegrationTest {
    @Rule
    public TemporaryFolder mTemp = new TemporaryFolder();
    protected static final String MOUNT_POINT = AlluxioTestDirectory.createTemporaryDirectory((String)"fuse_mount").toString();
    private static final String PAGING_STORE_DIR = AlluxioTestDirectory.createTemporaryDirectory((String)"paging_store_dir").toString();
    private AlluxioJniFuseFileSystem mFuseFileSystem;
    protected MiniDFSCluster mHdfsCluster;
    protected final org.apache.hadoop.conf.Configuration mHdfsConfiguration = new org.apache.hadoop.conf.Configuration();
    protected static final int HDFS_BLOCK_SIZE = 0x100000;
    private static final int HDFS_NAMENODE_PORT = 9870;
    protected FileSystem mHdfs;
    @Rule
    public LocalAlluxioClusterResource mAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED, true).setProperty(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES, 1024).setProperty(PropertyKey.FUSE_MOUNT_POINT, MOUNT_POINT).setProperty(PropertyKey.WORKER_PAGE_STORE_DIRS, PAGING_STORE_DIR).setProperty(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS, "hdfs://localhost:9870/").setProperty(PropertyKey.DORA_CLIENT_UFS_ROOT, "hdfs://localhost:9870/").setStartCluster(false).build();

    @BeforeClass
    public static void beforeClass() {
    }

    @Before
    public void before() throws Exception {
        this.initHdfsMiniCluster();
        this.mAlluxioClusterResource.start();
        this.mountFuse();
    }

    @After
    public void after() throws Exception {
        this.mFuseFileSystem.umount(true);
        if (this.mHdfsCluster != null) {
            this.mHdfsCluster.shutdown();
        }
    }

    private void initHdfsMiniCluster() throws IOException {
        this.mHdfsConfiguration.set("dfs.name.dir", this.mTemp.newFolder("nn").getAbsolutePath());
        this.mHdfsConfiguration.set("dfs.data.dir", this.mTemp.newFolder("dn").getAbsolutePath());
        this.mHdfsConfiguration.setInt("dfs.block.size", 0x100000);
        this.mHdfsCluster = new MiniDFSCluster.Builder(this.mHdfsConfiguration).enableManagedDfsDirsRedundancy(false).manageDataDfsDirs(false).manageNameDfsDirs(false).nameNodePort(9870).numDataNodes(1).build();
        this.mHdfs = this.mHdfsCluster.getFileSystem();
    }

    private void mountFuse() throws IOException {
        UfsFileSystemOptions ufsOptions = new UfsFileSystemOptions("/");
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)Configuration.global());
        FileSystemOptions fileSystemOptions = FileSystemOptions.Builder.fromConf((AlluxioConfiguration)Configuration.global()).setUfsFileSystemOptions(ufsOptions).build();
        this.mFuseFileSystem = new AlluxioJniFuseFileSystem(fsContext, this.mAlluxioClusterResource.get().getClient(), FuseOptions.create((AlluxioConfiguration)Configuration.global(), (FileSystemOptions)fileSystemOptions, (boolean)false));
        this.mFuseFileSystem.mount(false, false, new HashSet());
        if (!FuseUtils.waitForFuseMounted(MOUNT_POINT)) {
            FuseUtils.umountFromShellIfMounted(MOUNT_POINT);
            Assert.fail((String)"Could not setup FUSE mount point");
        }
    }
}

