/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.hdfs3;

import alluxio.client.fuse.dora.hdfs3.AbstractFuseHdfsIntegrationTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.fuse.AlluxioFuseUtils;
import alluxio.jnifuse.LibFuse;
import alluxio.jnifuse.utils.LibfuseVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FuseHdfsIntegrationTest
extends AbstractFuseHdfsIntegrationTest {
    @BeforeClass
    public static void beforeClass() {
        LibFuse.loadLibrary((LibfuseVersion)AlluxioFuseUtils.getLibfuseVersion((AlluxioConfiguration)Configuration.global()));
    }

    @Test
    public void createDeleteEmptyFile() throws Exception {
        String testFile = Paths.get(MOUNT_POINT, "/createDeleteEmptyFile").toString();
        File file = new File(testFile);
        Assert.assertFalse((boolean)file.exists());
        new FileOutputStream(testFile).close();
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)this.mHdfs.exists(new Path("/createDeleteEmptyFile")));
        Assert.assertEquals((long)0L, (long)file.length());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void writeThenRead() throws Exception {
        byte[] res2;
        String testFile = Paths.get(MOUNT_POINT, "/writeThenRead").toString();
        byte[] content = "Alluxio Fuse Test File Content".getBytes();
        File file = new File(testFile);
        Assert.assertFalse((boolean)file.exists());
        try (FileOutputStream outputStream = new FileOutputStream(testFile);){
            outputStream.write(content);
        }
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isFile());
        Assert.assertEquals((long)content.length, (long)file.length());
        var5_5 = null;
        try (FileInputStream inputStream = new FileInputStream(testFile);){
            res2 = new byte[content.length];
            Assert.assertEquals((long)content.length, (long)inputStream.read(res2));
            Assert.assertEquals((Object)Arrays.toString(content), (Object)Arrays.toString(res2));
        }
        catch (Throwable res2) {
            var5_5 = res2;
            throw res2;
        }
        inputStream = this.mHdfs.open(new Path("/writeThenRead"));
        var5_5 = null;
        try {
            res2 = new byte[content.length];
            Assert.assertEquals((long)content.length, (long)inputStream.read(res2));
            Assert.assertEquals((Object)Arrays.toString(content), (Object)Arrays.toString(res2));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var5_5 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        Assert.assertTrue((boolean)file.delete());
        Assert.assertFalse((boolean)file.exists());
    }
}

