/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.readonly;

import alluxio.client.fuse.dora.readonly.AbstractFuseFileSystemTest;
import alluxio.jnifuse.ErrorCodes;
import alluxio.util.io.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Test;

public class FuseDoraReadOnlyTest
extends AbstractFuseFileSystemTest {
    @Test
    public void readWriteEmptyNonExisting() {
        this.mFileInfo.get().flags.set(OpenFlags.O_RDWR.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open("/file", this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release("/file", this.mFileInfo.get()));
        Assert.assertEquals((long)(-ErrorCodes.ENOENT()), (long)this.mFuseFs.getattr("/file", this.mFileStat));
    }

    @Test
    public void emptyFileRead() throws IOException {
        this.createEmptyFile(UFS_ROOT.join("/file").toString());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.getattr("/file", this.mFileStat));
        Assert.assertEquals((long)0L, (long)this.mFileStat.st_size.intValue());
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open("/file", this.mFileInfo.get()));
        ByteBuffer buffer = ByteBuffer.allocate(64);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.read("/file", buffer, 64L, 0L, this.mFileInfo.get()));
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release("/file", this.mFileInfo.get()));
    }

    @Test
    public void readExisting() throws IOException {
        this.createFile(UFS_ROOT.join("/file").toString(), 64);
        this.mFileInfo.get().flags.set(OpenFlags.O_RDONLY.intValue());
        Assert.assertEquals((long)0L, (long)this.mFuseFs.open("/file", this.mFileInfo.get()));
        ByteBuffer buffer = ByteBuffer.allocate(64);
        Assert.assertEquals((long)64L, (long)this.mFuseFs.read("/file", buffer, 64L, 0L, this.mFileInfo.get()));
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)buffer);
        Assert.assertEquals((long)0L, (long)this.mFuseFs.release("/file", this.mFileInfo.get()));
    }
}

