/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.readonly.stream;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.dora.readonly.AbstractFuseDoraReadOnlyTest;
import alluxio.conf.AlluxioConfiguration;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.auth.LaunchUserGroupAuthPolicy;
import alluxio.fuse.file.FuseStreamFactory;
import alluxio.fuse.file.SimpleFuseStreamFactory;
import alluxio.grpc.OpenFilePOptions;
import alluxio.security.authorization.Mode;
import alluxio.util.io.BufferUtils;
import java.io.FileOutputStream;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractStreamTest
extends AbstractFuseDoraReadOnlyTest {
    protected static final Mode DEFAULT_MODE = new Mode(Mode.Bits.ALL, Mode.Bits.READ, Mode.Bits.READ);
    protected FuseStreamFactory mStreamFactory;

    @Override
    @Before
    public void beforeActions() {
        LaunchUserGroupAuthPolicy authPolicy = LaunchUserGroupAuthPolicy.create((FileSystem)this.mFileSystem, (AlluxioConfiguration)this.mContext.getClusterConf(), Optional.empty());
        authPolicy.init();
        this.mStreamFactory = new SimpleFuseStreamFactory(this.mFileSystem, (AuthPolicy)authPolicy);
    }

    @Override
    public void afterActions() {
    }

    protected AlluxioURI getTestFileUri() {
        return UFS_ROOT.join("/file" + UUID.randomUUID());
    }

    protected void writeIncreasingByteArrayToFile(AlluxioURI filePath, int fileLen) throws Exception {
        try (FileOutputStream os = new FileOutputStream(filePath.toString());){
            os.write(BufferUtils.getIncreasingByteArray((int)fileLen));
        }
    }

    protected void checkFile(AlluxioURI filePath, int fileLen, int startValue) throws Exception {
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((long)fileLen, (long)status.getLength());
        try (FileInStream is = this.mFileSystem.openFile(filePath, OpenFilePOptions.newBuilder().build());){
            byte[] res = new byte[(int)status.getLength()];
            Assert.assertEquals((long)((int)status.getLength()), (long)is.read(res));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)startValue, (int)fileLen, (byte[])res));
        }
    }
}

