/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.stream;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.dora.stream.OutStreamTest;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.file.FuseFileStream;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Test;

public class InOrOutStreamOutTest
extends OutStreamTest {
    @Override
    protected FuseFileStream createStream(AlluxioURI uri, boolean truncate) {
        int flags = OpenFlags.O_RDWR.intValue();
        if (truncate) {
            flags |= OpenFlags.O_TRUNC.intValue();
        }
        return this.mStreamFactory.create(uri, flags, (long)DEFAULT_MODE.toShort());
    }

    @Override
    @Test(expected=UnimplementedRuntimeException.class)
    public void read() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream outStream = this.createStream(alluxioURI, false);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            outStream.write(buffer, 64L, 0L);
            outStream.read(buffer, 64L, 0L);
        }
    }

    @Override
    @Test(expected=FileDoesNotExistException.class)
    public void createEmpty() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.createStream(alluxioURI, false).close();
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
    }
}

