/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.dora.stream;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.dora.stream.AbstractStreamTest;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.file.FuseFileStream;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class InStreamTest
extends AbstractStreamTest {
    @Test
    public void createRead() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        URIStatus uriStatus = this.mFileSystem.getStatus(alluxioURI);
        try (FuseFileStream inStream = this.createStream(alluxioURI);){
            Assert.assertEquals((long)uriStatus.getLength(), (long)inStream.getFileStatus().getFileLength());
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)inStream.read(buffer, 64L, 0L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)buffer));
            Assert.assertEquals((long)uriStatus.getLength(), (long)inStream.getFileStatus().getFileLength());
        }
    }

    @Test(expected=NotFoundRuntimeException.class)
    public void createNonexisting() {
        AlluxioURI alluxioURI = this.getTestFileUri();
        try (FuseFileStream inStream = this.createStream(alluxioURI);){
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)inStream.read(buffer, 64L, 0L));
        }
    }

    @Test
    public void randomRead() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.createStream(alluxioURI);){
            ByteBuffer buffer = ByteBuffer.allocate(32);
            Assert.assertEquals((long)32L, (long)inStream.read(buffer, 32L, 32L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)32, (int)32, (ByteBuffer)buffer));
            buffer.clear();
            Assert.assertEquals((long)32L, (long)inStream.read(buffer, 32L, 21L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)21, (int)32, (ByteBuffer)buffer));
        }
    }

    @Test(expected=FailedPreconditionRuntimeException.class)
    public void write() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.createStream(alluxioURI);){
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)97);
            inStream.write(buffer, 1L, 0L);
        }
    }

    @Ignore(value="RandomAccessFuseFileStream allows to execute truncate operation")
    @Test(expected=UnimplementedRuntimeException.class)
    public void truncate() throws Exception {
        AlluxioURI alluxioURI = this.getTestFileUri();
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.createStream(alluxioURI);){
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)inStream.read(buffer, 64L, 0L));
            inStream.truncate(0L);
        }
    }

    protected FuseFileStream createStream(AlluxioURI uri) {
        return this.mStreamFactory.create(uri, OpenFlags.O_RDONLY.intValue(), (long)DEFAULT_MODE.toShort());
    }
}

