/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.file;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.fuse.auth.AuthPolicy;
import alluxio.fuse.auth.LaunchUserGroupAuthPolicy;
import alluxio.fuse.file.FuseStreamFactory;
import alluxio.fuse.file.SimpleFuseStreamFactory;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import alluxio.grpc.WritePType;
import alluxio.testutils.BaseIntegrationTest;
import alluxio.testutils.LocalAlluxioClusterResource;
import alluxio.util.io.BufferUtils;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractFuseFileStreamIntegrationTest
extends BaseIntegrationTest {
    protected static final int DEFAULT_FILE_LEN = 64;
    protected static final long MODE = 10644L;
    @Rule
    public LocalAlluxioClusterResource mLocalAlluxioClusterResource = new LocalAlluxioClusterResource.Builder().setProperty(PropertyKey.FUSE_AUTH_POLICY_CLASS, "alluxio.fuse.auth.LaunchUserGroupAuthPolicy").setProperty(PropertyKey.USER_METADATA_CACHE_MAX_SIZE, 0).setProperty(PropertyKey.MASTER_WORKER_REGISTER_LEASE_ENABLED, false).build();
    protected FileSystem mFileSystem = null;
    protected AuthPolicy mAuthPolicy = null;
    protected FuseStreamFactory mStreamFactory = null;

    @Before
    public void before() throws Exception {
        this.mFileSystem = this.mLocalAlluxioClusterResource.get().getClient();
        this.mAuthPolicy = LaunchUserGroupAuthPolicy.create((FileSystem)this.mFileSystem, (AlluxioConfiguration)this.mLocalAlluxioClusterResource.get().getClient().getConf(), Optional.empty());
        this.mAuthPolicy.init();
        this.mStreamFactory = new SimpleFuseStreamFactory(this.mFileSystem, this.mAuthPolicy);
    }

    protected void writeIncreasingByteArrayToFile(AlluxioURI filePath, int fileLen) throws Exception {
        try (FileOutStream os = this.mFileSystem.createFile(filePath, CreateFilePOptions.newBuilder().setWriteType(WritePType.MUST_CACHE).setRecursive(true).build());){
            os.write(BufferUtils.getIncreasingByteArray((int)fileLen));
        }
    }

    protected void checkFileInAlluxio(AlluxioURI filePath, int fileLen, int startValue) throws Exception {
        URIStatus status = this.mFileSystem.getStatus(filePath);
        Assert.assertEquals((long)fileLen, (long)status.getLength());
        try (FileInStream is = this.mFileSystem.openFile(filePath, OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build());){
            byte[] res = new byte[(int)status.getLength()];
            Assert.assertEquals((long)((int)status.getLength()), (long)is.read(res));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteArray((int)startValue, (int)fileLen, (byte[])res));
        }
    }
}

