/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.file;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.file.AbstractFuseFileStreamIntegrationTest;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.file.FuseFileStream;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FuseFileInOrOutStreamIntegrationTest
extends AbstractFuseFileStreamIntegrationTest {
    @Test
    public void createNonexistingClose() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue() | OpenFlags.O_CREAT.intValue(), 10644L).close();
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertEquals((long)0L, (long)status.getLength());
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void createExistingClose() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L).close();
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertEquals((long)64L, (long)status.getLength());
    }

    @Test
    public void openTruncate() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.mFileSystem.createFile(alluxioURI).close();
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            stream.truncate(64L);
        }
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertEquals((long)64L, (long)status.getLength());
    }

    @Test
    public void createTruncateFlagClose() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue() | OpenFlags.O_TRUNC.intValue(), 10644L).close();
        URIStatus status = this.mFileSystem.getStatus(alluxioURI);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((boolean)status.isCompleted());
        Assert.assertEquals((long)0L, (long)status.getLength());
    }

    @Test(expected=UnimplementedRuntimeException.class)
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void createTruncateFlagRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue() | OpenFlags.O_TRUNC.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(64);
            stream.read(buffer, 64L, 0L);
        }
    }

    @Test
    public void createTruncateFlagWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        int newFileLength = 30;
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue() | OpenFlags.O_TRUNC.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)0, (int)newFileLength);
            stream.write(buffer, (long)newFileLength, 0L);
        }
        this.checkFileInAlluxio(alluxioURI, newFileLength, 0);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void createTruncateZeroWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        int newFileLength = 45;
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            Assert.assertEquals((long)64L, (long)stream.getFileStatus().getFileLength());
            stream.truncate(0L);
            Assert.assertEquals((long)0L, (long)stream.getFileStatus().getFileLength());
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)0, (int)newFileLength);
            stream.write(buffer, (long)newFileLength, 0L);
            Assert.assertEquals((long)newFileLength, (long)stream.getFileStatus().getFileLength());
        }
        this.checkFileInAlluxio(alluxioURI, newFileLength, 0);
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void sequentialRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        URIStatus uriStatus = this.mFileSystem.getStatus(alluxioURI);
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            Assert.assertEquals((long)uriStatus.getLength(), (long)stream.getFileStatus().getFileLength());
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)stream.read(buffer, 64L, 0L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)buffer));
            Assert.assertEquals((long)uriStatus.getLength(), (long)stream.getFileStatus().getFileLength());
        }
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void randomRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(32);
            Assert.assertEquals((long)32L, (long)stream.read(buffer, 32L, 21L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)21, (int)32, (ByteBuffer)buffer));
        }
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void sequentialWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            stream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)stream.getFileStatus().getFileLength());
            buffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)64);
            stream.write(buffer, 64L, 64L);
            Assert.assertEquals((long)128L, (long)stream.getFileStatus().getFileLength());
        }
        this.checkFileInAlluxio(alluxioURI, 128, 0);
    }

    @Test
    public void truncateZeroOrDefault() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            stream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)stream.getFileStatus().getFileLength());
            stream.truncate(0L);
            Assert.assertEquals((long)0L, (long)stream.getFileStatus().getFileLength());
            buffer = BufferUtils.getIncreasingByteBuffer((int)128);
            stream.write(buffer, 128L, 0L);
            Assert.assertEquals((long)128L, (long)stream.getFileStatus().getFileLength());
            stream.truncate(128L);
            Assert.assertEquals((long)128L, (long)stream.getFileStatus().getFileLength());
        }
        this.checkFileInAlluxio(alluxioURI, 128, 0);
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void randomWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            stream.write(buffer, 64L, 15L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void readThenWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)stream.read(buffer, 64L, 0L));
            stream.write(buffer, 64L, 0L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void writeThenRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            stream.write(buffer, 64L, 0L);
            stream.read(buffer, 64L, 0L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void readTruncateZero() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)stream.read(buffer, 64L, 0L));
            stream.truncate(0L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void truncateMiddle() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        try (FuseFileStream stream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
            ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
            stream.write(buffer, 64L, 0L);
            Assert.assertEquals((long)64L, (long)stream.getFileStatus().getFileLength());
            stream.truncate(32L);
        }
    }
}

