/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.file;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.file.URIStatus;
import alluxio.client.fuse.file.AbstractFuseFileStreamIntegrationTest;
import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.exception.runtime.UnimplementedRuntimeException;
import alluxio.fuse.file.FuseFileStream;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FuseFileInStreamIntegrationTest
extends AbstractFuseFileStreamIntegrationTest {
    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void createRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        URIStatus uriStatus = this.mFileSystem.getStatus(alluxioURI);
        try (FuseFileStream inStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L);){
            Assert.assertEquals((long)uriStatus.getLength(), (long)inStream.getFileStatus().getFileLength());
            ByteBuffer buffer = ByteBuffer.allocate(64);
            Assert.assertEquals((long)64L, (long)inStream.read(buffer, 64L, 0L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)buffer));
            Assert.assertEquals((long)uriStatus.getLength(), (long)inStream.getFileStatus().getFileLength());
        }
    }

    @Test(expected=NotFoundRuntimeException.class)
    public void createNonexisting() {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L).close();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void randomRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(32);
            Assert.assertEquals((long)32L, (long)inStream.read(buffer, 32L, 21L));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)21, (int)32, (ByteBuffer)buffer));
        }
    }

    @Test(expected=FailedPreconditionRuntimeException.class)
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void write() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L);){
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)97);
            inStream.write(buffer, 1L, 0L);
        }
    }

    @Test(expected=UnimplementedRuntimeException.class)
    public void truncate() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.writeIncreasingByteArrayToFile(alluxioURI, 64);
        try (FuseFileStream inStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L);){
            inStream.truncate(0L);
        }
    }
}

