/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.fuse.file;

import alluxio.AlluxioURI;
import alluxio.annotation.dora.DoraTestTodoItem;
import alluxio.client.fuse.file.AbstractFuseFileStreamIntegrationTest;
import alluxio.fuse.file.FuseFileStream;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.util.io.BufferUtils;
import alluxio.util.io.PathUtils;
import java.nio.ByteBuffer;
import jnr.constants.platform.OpenFlags;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class MixedFuseStreamIntegrationTest
extends AbstractFuseFileStreamIntegrationTest {
    @Test
    public void writeThenOpenRead() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        FuseFileStream outStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_WRONLY.intValue(), 10644L);
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        outStream.write(buffer, 64L, 0L);
        Thread thread = new Thread(() -> {
            try (FuseFileStream inStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDONLY.intValue(), 10644L);){
                ByteBuffer readBuffer = ByteBuffer.allocate(64);
                Assert.assertEquals((long)64L, (long)inStream.read(readBuffer, 64L, 0L));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)readBuffer));
            }
        });
        thread.start();
        outStream.close();
        thread.join();
    }

    @Test
    public void writeThenOpenReadWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        FuseFileStream outStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_WRONLY.intValue(), 10644L);
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        outStream.write(buffer, 64L, 0L);
        Thread thread = new Thread(() -> {
            try (FuseFileStream inOrOutStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue(), 10644L);){
                ByteBuffer readBuffer = ByteBuffer.allocate(64);
                Assert.assertEquals((long)64L, (long)inOrOutStream.read(readBuffer, 64L, 0L));
                Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)64, (ByteBuffer)readBuffer));
            }
        });
        thread.start();
        outStream.close();
        thread.join();
    }

    @Test
    @Ignore
    @DoraTestTodoItem(action=DoraTestTodoItem.Action.FIX, owner="hua", comment="fix the test case")
    public void writeThenOverwrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        FuseFileStream outStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_WRONLY.intValue(), 10644L);
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        outStream.write(buffer, 64L, 0L);
        Thread thread = new Thread(() -> {
            try (FuseFileStream overwriteStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_WRONLY.intValue() | OpenFlags.O_TRUNC.intValue(), 10644L);){
                ByteBuffer newBuffer = BufferUtils.getIncreasingByteBuffer((int)64);
                overwriteStream.write(newBuffer, 64L, 0L);
                newBuffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)64);
                overwriteStream.write(newBuffer, 64L, 64L);
            }
        });
        thread.start();
        outStream.close();
        thread.join();
        this.checkFileInAlluxio(alluxioURI, 128, 0);
    }

    @Test
    public void writeThenOverwriteReadWrite() throws Exception {
        AlluxioURI alluxioURI = new AlluxioURI(PathUtils.uniqPath());
        this.mFileSystem.createDirectory(alluxioURI.getParent(), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        FuseFileStream outStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_WRONLY.intValue(), 10644L);
        ByteBuffer buffer = BufferUtils.getIncreasingByteBuffer((int)64);
        outStream.write(buffer, 64L, 0L);
        Thread thread = new Thread(() -> {
            try (FuseFileStream inOrOutStream = this.mStreamFactory.create(alluxioURI, OpenFlags.O_RDWR.intValue() | OpenFlags.O_TRUNC.intValue(), 10644L);){
                ByteBuffer newBuffer = BufferUtils.getIncreasingByteBuffer((int)64);
                inOrOutStream.write(newBuffer, 64L, 0L);
                newBuffer = BufferUtils.getIncreasingByteBuffer((int)64, (int)64);
                inOrOutStream.write(newBuffer, 64L, 64L);
            }
        });
        thread.start();
        outStream.close();
        thread.join();
        this.checkFileInAlluxio(alluxioURI, 128, 0);
    }
}

